/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.localization.LocalizationSupport;

public class BoundValidator
implements Validator<String> {
    private final int value;
    private final boolean less;

    BoundValidator(int value, boolean less) {
        this.value = value;
        this.less = less;
    }

    @Override
    public void validate(Problems problems, String compName, String model) {
        try {
            boolean test;
            int val = (int)Double.parseDouble(model);
            boolean bl = this.less ? val < this.value : (test = val > this.value);
            if (!test) {
                String problem = LocalizationSupport.getMessage(BoundValidator.class, this.less ? "ERR_TOO_LARGE" : "ERR_TOO_SMALL", compName, model);
                problems.append(problem);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public Class<String> modelType() {
        return String.class;
    }
}

