/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.actions;

import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.payara.common.PayaraInstanceProvider;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RemoveServerAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            ServerInstance si = this.getServerInstance(nodes[i]);
            if (si == null || !si.isRemovable()) continue;
            String title = NbBundle.getMessage(RemoveServerAction.class, (String)"MSG_RemoveServerTitle", (Object)si.getDisplayName());
            String msg = NbBundle.getMessage(RemoveServerAction.class, (String)"MSG_RemoveServerMessage", (Object)si.getDisplayName());
            NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)msg, title, 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.YES_OPTION) continue;
            si.remove();
        }
    }

    private ServerInstance getServerInstance(Node node) {
        ServerInstance si = null;
        PayaraModule commonSupport = (PayaraModule)node.getLookup().lookup(PayaraModule.class);
        if (commonSupport != null) {
            String uri = commonSupport.getInstanceProperties().get("url");
            PayaraInstanceProvider pip = commonSupport.getInstanceProvider();
            si = pip.getInstance(uri);
        }
        return si;
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean result = true;
        for (int i = 0; i < activatedNodes.length; ++i) {
            ServerInstance si = this.getServerInstance(activatedNodes[i]);
            if (si != null && si.isRemovable()) continue;
            result = false;
            break;
        }
        return result;
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(RemoveServerAction.class, (String)"CTL_RemoveServerAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

