/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.repository;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.bugtracking.commons.LinkButton;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class NBLoginPanel
extends JPanel {
    private final JButton login = new JButton(NbBundle.getMessage(NBLoginPanel.class, (String)"LBL_Login"));
    private final JButton cancel = new JButton(NbBundle.getMessage(NBLoginPanel.class, (String)"LBL_Cancel"));
    private JLabel errorLabel;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPasswordField passwordField;
    private JTextField usernameTextField;

    NBLoginPanel() {
        this.initComponents();
        this.errorLabel.setVisible(false);
        this.login.getAccessibleContext().setAccessibleDescription(this.login.getText());
        this.cancel.getAccessibleContext().setAccessibleDescription(this.cancel.getText());
        this.usernameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NBLoginPanel.this.validateFields();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NBLoginPanel.this.validateFields();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NBLoginPanel.this.validateFields();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.usernameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jButton1 = new LinkButton((Action)new NBRegisterAction());
        this.passwordField = new JPasswordField();
        this.errorLabel = new JLabel();
        this.jLabel1.setText(NbBundle.getMessage(NBLoginPanel.class, (String)"NBLoginPanel.jLabel1.text"));
        this.usernameTextField.setText(NbBundle.getMessage(NBLoginPanel.class, (String)"NBLoginPanel.usernameTextField.text"));
        this.jLabel2.setText(NbBundle.getMessage(NBLoginPanel.class, (String)"NBLoginPanel.jLabel2.text"));
        this.jLabel3.setText(NbBundle.getMessage(NBLoginPanel.class, (String)"NBLoginPanel.jLabel3.text"));
        this.jLabel4.setText(NbBundle.getMessage(NBLoginPanel.class, (String)"NBLoginPanel.jLabel4.text"));
        this.jButton1.setText(NbBundle.getMessage(NBLoginPanel.class, (String)"NBLoginPanel.jButton1.text"));
        this.passwordField.setText(NbBundle.getMessage(NBLoginPanel.class, (String)"NBLoginPanel.passwordField.text"));
        this.errorLabel.setForeground(BugzillaUtil.getErrorForegroundColor());
        this.errorLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/bugzilla/resources/error.gif")));
        this.errorLabel.setText(NbBundle.getMessage(NBLoginPanel.class, (String)"NBLoginPanel.errorLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.passwordField).addComponent(this.usernameTextField, -2, 141, -2))).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.errorLabel).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.usernameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.passwordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jButton1)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    static boolean show(BugzillaRepository repo, String errorMsg) {
        NBLoginPanel panel = new NBLoginPanel();
        panel.usernameTextField.setText(repo.getUsername());
        panel.passwordField.setText(new String(repo.getPassword()));
        panel.validateFields();
        panel.updateErrorMessage(errorMsg);
        if (panel.showLogin()) {
            repo.setInfoValues(panel.usernameTextField.getText(), panel.passwordField.getPassword());
            return true;
        }
        return false;
    }

    private boolean showLogin() {
        DialogDescriptor descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(NBLoginPanel.class, (String)"LBL_LOGIN_2_NBORG"), true, new Object[]{this.login, this.cancel}, (Object)this.login, 0, new HelpCtx("org.netbeans.modules.bugzilla.api.NBLoginPanel"), null);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == this.login;
    }

    private void validateFields() {
        if (this.usernameTextField.getText().trim().equals("")) {
            this.login.setEnabled(false);
            this.updateErrorMessage(NbBundle.getMessage(NBLoginPanel.class, (String)"MSG_MISSING_USERNAME_PASSWORD"));
        } else {
            this.login.setEnabled(true);
            this.updateErrorMessage(null);
        }
    }

    private void updateErrorMessage(String errorMsg) {
        if (errorMsg != null) {
            this.errorLabel.setVisible(true);
            this.errorLabel.setText(errorMsg);
        } else {
            this.errorLabel.setVisible(false);
            this.errorLabel.setText("");
        }
    }

    private class NBRegisterAction
    extends AbstractAction {
        private NBRegisterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("https://netbeans.org/people/new"));
            }
            catch (MalformedURLException ex) {
                Bugzilla.LOG.log(Level.SEVERE, "Name", ex);
            }
        }
    }
}

