/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class StashApplyCommand
extends GitCommand {
    private final String stashRef;

    public StashApplyCommand(Repository repository, GitClassFactory accessor, int stashIndex, ProgressMonitor monitor) {
        super(repository, accessor, monitor);
        this.stashRef = "stash@{" + stashIndex + "}";
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            new Git(repository).stashApply().setStashRef(this.stashRef).call();
        }
        catch (GitAPIException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        return "git stash apply " + this.stashRef;
    }
}

