/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.io.AutoCRLFOutputStream;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class CatCommand
extends GitCommand {
    private final String revision;
    private final File file;
    private final OutputStream os;
    private final ProgressMonitor monitor;
    private String relativePath;
    private boolean found;
    private final boolean fromRevision;
    private final int stage;

    public CatCommand(Repository repository, GitClassFactory gitFactory, File file, String revision, OutputStream out, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.file = file;
        this.revision = revision;
        this.os = out;
        this.monitor = monitor;
        this.fromRevision = true;
        this.stage = 0;
    }

    public CatCommand(Repository repository, GitClassFactory gitFactory, File file, int stage, OutputStream out, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.file = file;
        this.revision = null;
        this.os = out;
        this.monitor = monitor;
        this.fromRevision = false;
        this.stage = stage;
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean retval = super.prepareCommand();
        if (retval) {
            this.relativePath = Utils.getRelativePath(this.getRepository().getWorkTree(), this.file);
            if (this.relativePath.isEmpty()) {
                String message = MessageFormat.format(Utils.getBundle(CatCommand.class).getString("MSG_Error_CannotCatRoot"), this.file);
                this.monitor.preparationsFailed(message);
                throw new GitException(message);
            }
        }
        return retval;
    }

    @Override
    protected void run() throws GitException {
        if (this.fromRevision) {
            this.catFromRevision();
        } else {
            this.catIndexEntry();
        }
    }

    private void catFromRevision() throws GitException.MissingObjectException, GitException {
        Repository repository = this.getRepository();
        OutputStream out = null;
        try {
            RevCommit commit = Utils.findCommit(repository, this.revision);
            TreeWalk walk = new TreeWalk(repository);
            walk.reset();
            walk.addTree((AnyObjectId)commit.getTree());
            walk.setFilter((TreeFilter)PathFilter.create((String)this.relativePath));
            walk.setRecursive(true);
            this.found = false;
            while (!this.found && walk.next() && !this.monitor.isCanceled()) {
                if (!this.relativePath.equals(walk.getPathString())) continue;
                WorkingTreeOptions opt = (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY);
                ObjectLoader loader = repository.getObjectDatabase().open((AnyObjectId)walk.getObjectId(0));
                out = opt.getAutoCRLF() != CoreConfig.AutoCRLF.FALSE ? new AutoCRLFOutputStream(this.os) : this.os;
                loader.copyTo(this.os);
                this.found = true;
            }
        }
        catch (MissingObjectException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        finally {
            try {
                if (out == null) {
                    this.os.close();
                } else {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void catIndexEntry() throws GitException {
        Repository repository = this.getRepository();
        OutputStream out = null;
        try {
            DirCache cache = repository.readDirCache();
            int pos = cache.findEntry(this.relativePath);
            DirCacheEntry entry = null;
            if (pos >= 0) {
                DirCacheEntry e = cache.getEntry(pos);
                do {
                    if (this.stage != e.getStage()) continue;
                    entry = e;
                } while (entry == null && ++pos < cache.getEntryCount() && this.relativePath.equals((e = cache.getEntry(pos)).getPathString()));
            }
            this.found = false;
            if (entry != null) {
                this.found = true;
                WorkingTreeOptions opt = (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY);
                ObjectLoader loader = repository.getObjectDatabase().open((AnyObjectId)entry.getObjectId());
                out = opt.getAutoCRLF() != CoreConfig.AutoCRLF.FALSE ? new AutoCRLFOutputStream(this.os) : this.os;
                loader.copyTo(this.os);
                this.found = true;
            }
        }
        catch (NoWorkTreeException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        finally {
            try {
                if (out == null) {
                    this.os.close();
                } else {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected String getCommandDescription() {
        return "git show " + this.revision + " " + this.file;
    }

    public boolean foundInRevision() {
        return this.found;
    }
}

