/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.projectimport.eclipse.core.ProjectImporterException;
import org.openide.ErrorManager;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

final class PreferredVMParser
extends DefaultHandler {
    private static final Logger logger = Logger.getLogger(PreferredVMParser.class.getName());
    private static final String VM_SETTINGS = "vmSettings";
    private static final String VM_TYPE = "vmType";
    private static final String VM = "vm";
    private static final String LIBRARY_LOCATIONS = "libraryLocations";
    private static final String LIBRARY_LOCATION = "libraryLocation";
    private static final String DEFAULT_VM_ATTR = "defaultVM";
    private static final String ID_ATTR = "id";
    private static final String NAME_ATTR = "name";
    private static final String PATH_ATTR = "path";
    private static final int POSITION_NONE = 0;
    private static final int POSITION_VM_SETTINGS = 1;
    private static final int POSITION_VM_TYPE = 2;
    private static final int POSITION_VM = 3;
    private static final int POSITION_LIBRARY_LOCATIONS = 4;
    private static final int POSITION_LIBRARY_LOCATION = 5;
    private int position = 0;
    private StringBuffer chars;
    private String defaultId;
    private Map<String, String> jdks;

    private PreferredVMParser() {
    }

    static Map<String, String> parse(String vmXML) throws ProjectImporterException {
        PreferredVMParser parser = new PreferredVMParser();
        parser.load(new InputSource(new StringReader(vmXML)));
        return parser.jdks;
    }

    private void load(InputSource vmXMLIS) throws ProjectImporterException {
        try {
            XMLReader reader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
            reader.setContentHandler(this);
            reader.setErrorHandler(this);
            this.chars = new StringBuffer();
            reader.parse(vmXMLIS);
        }
        catch (IOException e) {
            throw new ProjectImporterException(e);
        }
        catch (SAXException e) {
            throw new ProjectImporterException(e);
        }
    }

    @Override
    public void characters(char[] ch, int offset, int length) throws SAXException {
        this.chars.append(ch, offset, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.chars.setLength(0);
        switch (this.position) {
            case 0: {
                if (localName.equals(VM_SETTINGS)) {
                    this.position = 1;
                    String defaultVMAttr = attributes.getValue(DEFAULT_VM_ATTR);
                    this.defaultId = defaultVMAttr.substring(defaultVMAttr.lastIndexOf(44) + 1);
                    this.jdks = new HashMap<String, String>();
                    break;
                }
                throw new SAXException("First element has to be vmSettings, but is " + localName);
            }
            case 1: {
                if (!localName.equals(VM_TYPE)) break;
                this.position = 2;
                break;
            }
            case 2: {
                if (!localName.equals(VM)) break;
                this.position = 3;
                this.addJDK(attributes.getValue(ID_ATTR), attributes.getValue(NAME_ATTR), attributes.getValue(PATH_ATTR));
                break;
            }
            case 3: {
                if (!localName.equals(LIBRARY_LOCATIONS)) break;
                this.position = 4;
                logger.info("JRE used by your project presuambly contains additional jars. This is not supported (imported) yet. CC yourself to issue http://www.netbeans.org/issues/show_bug.cgi?id=70733 to watch a progress.");
                break;
            }
            case 4: {
                if (!localName.equals(LIBRARY_LOCATION)) break;
                this.position = 5;
                break;
            }
            default: {
                throw new SAXException("Unknown position reached: " + this.position + " (element: " + localName + ")");
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (this.position) {
            case 1: {
                this.position = 0;
                break;
            }
            case 2: {
                this.position = 1;
                break;
            }
            case 3: {
                this.position = 2;
                break;
            }
            case 4: {
                this.position = 3;
                break;
            }
            case 5: {
                this.position = 4;
                break;
            }
            default: {
                ErrorManager.getDefault().log(16, "Unknown state reached in ClassPathParser, position: " + this.position);
            }
        }
        this.chars.setLength(0);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        ErrorManager.getDefault().log(16, "Error occurres: " + e);
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        ErrorManager.getDefault().log(16, "Fatal error occurres: " + e);
        throw e;
    }

    private void addJDK(String id, String name, String value) {
        if (id.equals(this.defaultId)) {
            this.jdks.put("org.eclipse.jdt.launching.JRE_CONTAINER", value);
        }
        this.jdks.put(name, value);
    }
}

