/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject.idenative;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.classpath.AbstractBootPathImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Project;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.modules.maven.newproject.idenative.IDENativeTemplateHandler;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.spi.newproject.CreateProjectBuilder;

public class SimpleJavaTemplateHandler
extends IDENativeTemplateHandler {
    @Override
    protected CreateProjectBuilder customizeBuilder(CreateProjectBuilder builder, ProjectInfo pi) {
        return super.customizeBuilder(builder, pi).setAdditionalNonPomWork(new CreateProjectBuilder.AdditionalChangeHandle(){

            @Override
            public Runnable createAdditionalChange(final CreateProjectBuilder.Context context) {
                return new Runnable(){

                    @Override
                    public void run() {
                        File src = new File(context.getProjectDirectory(), "src" + File.separator + "main" + File.separator + "java");
                        src.mkdirs();
                        if (context.getPackageName() != null) {
                            String path = context.getPackageName().replace(".", File.separator);
                            new File(src, path).mkdirs();
                        }
                    }
                };
            }
        }).setAdditionalOperations(new CreateProjectBuilder.PomOperationsHandle(){

            @Override
            public List<ModelOperation<POMModel>> createPomOperations(final CreateProjectBuilder.Context context) {
                return Collections.singletonList(new ModelOperation<POMModel>(){

                    public void performOperation(POMModel model) {
                        Project root;
                        MavenProject mp = context.getParent();
                        boolean setLevel = true;
                        if (mp != null) {
                            String source = PluginPropertyUtils.getPluginProperty(mp, "org.apache.maven.plugins", "maven-compiler-plugin", "source", "compile", "maven.compiler.source");
                            String target = PluginPropertyUtils.getPluginProperty(mp, "org.apache.maven.plugins", "maven-compiler-plugin", "target", "compile", "maven.compiler.target");
                            if (target != null || source != null) {
                                setLevel = false;
                            }
                        }
                        if (setLevel && (root = model.getProject()) != null) {
                            JavaPlatform active;
                            Properties props = root.getProperties();
                            if (props == null) {
                                props = model.getFactory().createProperties();
                                root.setProperties(props);
                            }
                            if ((active = AbstractBootPathImpl.getActivePlatform(MavenSettings.getDefault().getDefaultJdk())) == null) {
                                active = JavaPlatformManager.getDefault().getDefaultPlatform();
                            }
                            String version = active.getSpecification().getVersion().toString();
                            props.setProperty("maven.compiler.source", version);
                            props.setProperty("maven.compiler.target", version);
                        }
                    }
                });
            }
        });
    }
}

