/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.customizer;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.MavenProjectPropsImpl;
import org.netbeans.modules.maven.api.customizer.Bundle;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.execute.ActionToGoalUtils;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Reader;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.spi.project.ProjectConfiguration;

public class ModelHandle2 {
    public static final String PANEL_RUN = "RUN";
    public static final String PANEL_BASIC = "BASIC";
    public static final String PANEL_CONFIGURATION = "CONFIGURATION";
    public static final String PANEL_MAPPING = "MAPPING";
    public static final String PANEL_LIBRARIES = "LIBRARIES";
    public static final String PANEL_SOURCES = "SOURCES";
    public static final String PANEL_COMPILE = "COMPILE";
    public static final String PANEL_HEADERS = "LICENSE_HEADERS";
    private final MavenProjectPropsImpl auxiliaryProps;
    private final MavenProject project;
    private final POMModel model;
    private final List<ModelOperation<POMModel>> pomOperations = new ArrayList<ModelOperation<POMModel>>();
    private final Map<String, ActionToGoalMapping> mappings;
    private final List<String> allActions;
    private List<Configuration> configurations;
    private boolean modConfig = false;
    private Configuration active;
    TreeMap<String, String> transPropsShared = new TreeMap();
    TreeMap<String, String> transPropsPrivate = new TreeMap();
    Set<ActionToGoalMapping> modifiedMappings = new HashSet<ActionToGoalMapping>();

    private ModelHandle2(POMModel model, MavenProject proj, Map<String, ActionToGoalMapping> mapp, List<Configuration> configs, Configuration active, List<String> allActions, MavenProjectPropsImpl auxProps) {
        this.project = proj;
        this.mappings = mapp;
        this.configurations = configs;
        this.active = active;
        this.auxiliaryProps = auxProps;
        this.model = model;
        this.allActions = allActions;
    }

    public POMModel getPOMModel() {
        return this.model;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public String getRawAuxiliaryProperty(String propertyName, boolean shared) {
        if (shared && this.transPropsShared.containsKey(propertyName)) {
            return this.transPropsShared.get(propertyName);
        }
        if (!shared && this.transPropsPrivate.containsKey(propertyName)) {
            return this.transPropsPrivate.get(propertyName);
        }
        return this.auxiliaryProps.get(propertyName, shared, false);
    }

    public void setRawAuxiliaryProperty(String propertyName, String value, boolean shared) {
        if (shared) {
            this.transPropsShared.put(propertyName, value);
        } else {
            this.transPropsPrivate.put(propertyName, value);
        }
    }

    private TreeMap<String, String> getModifiedAuxProps(boolean shared) {
        if (shared) {
            return this.transPropsShared;
        }
        return this.transPropsPrivate;
    }

    public ActionToGoalMapping getActionMappings() {
        return this.mappings.get("%%DEFAULT%%");
    }

    public ActionToGoalMapping getActionMappings(Configuration config) {
        ActionToGoalMapping mapp = this.mappings.get(config.getId());
        if (mapp == null) {
            mapp = new ActionToGoalMapping();
            this.markAsModified(mapp);
            this.mappings.put(config.getId(), mapp);
        }
        return mapp;
    }

    public void markAsModified(ActionToGoalMapping mapp) {
        this.modifiedMappings.add(mapp);
    }

    public void markConfigurationsAsModified() {
        this.modConfig = true;
    }

    public List<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void addConfiguration(Configuration config) {
        assert (config != null);
        this.configurations.add(config);
        this.modConfig = true;
    }

    public void removeConfiguration(Configuration config) {
        assert (config != null);
        this.configurations.remove(config);
        if (this.active == config) {
            this.active = this.configurations.size() > 0 ? this.configurations.get(0) : null;
        }
        this.modConfig = true;
    }

    public Configuration getActiveConfiguration() {
        return this.active;
    }

    public void setActiveConfiguration(Configuration conf) {
        assert (conf != null);
        assert (this.configurations.contains(conf));
        this.active = conf;
    }

    public void addPOMModification(ModelOperation<POMModel> operation) {
        if (!this.pomOperations.contains(operation)) {
            this.pomOperations.add(operation);
        }
    }

    public void removePOMModification(ModelOperation<POMModel> operation) {
        this.pomOperations.remove(operation);
    }

    public List<ModelOperation<POMModel>> getPOMOperations() {
        return new ArrayList<ModelOperation<POMModel>>(this.pomOperations);
    }

    public static Configuration createProfileConfiguration(String id) {
        return ModelHandle.createProfileConfiguration(id);
    }

    public static Configuration createProvidedConfiguration(String id) {
        ModelHandle.Configuration conf = new ModelHandle.Configuration();
        conf.setId(id);
        conf.setDefault(true);
        return conf;
    }

    public static Configuration createDefaultConfiguration() {
        return ModelHandle.createDefaultConfiguration();
    }

    public static Configuration createCustomConfiguration(String id) {
        return ModelHandle.createCustomConfiguration(id);
    }

    public static void setUserActionMapping(NetbeansActionMapping action, ActionToGoalMapping mapp) {
        ArrayList<NetbeansActionMapping> lst = mapp.getActions() != null ? mapp.getActions() : new ArrayList<NetbeansActionMapping>();
        Iterator it = lst.iterator();
        while (it.hasNext()) {
            NetbeansActionMapping act = (NetbeansActionMapping)it.next();
            if (!act.getActionName().equals(action.getActionName())) continue;
            int index = lst.indexOf(act);
            it.remove();
            lst.add(index, action);
            return;
        }
        lst.add(action);
    }

    @CheckForNull
    public static NetbeansActionMapping getDefaultMapping(String action, Project project) {
        return ActionToGoalUtils.getDefaultMapping(action, project);
    }

    @CheckForNull
    public static NetbeansActionMapping getMapping(String action, Project project, ProjectConfiguration config) {
        return ActionToGoalUtils.getActiveMapping(action, project, (M2Configuration)config);
    }

    public static void putMapping(NetbeansActionMapping mapp, Project project, ProjectConfiguration config) throws IOException {
        ActionToGoalMapping mapping;
        M2Configuration cfg = (M2Configuration)config;
        try {
            mapping = new NetbeansBuildActionXpp3Reader().read(new StringReader(cfg.getRawMappingsAsString()));
        }
        catch (XmlPullParserException x) {
            throw new IOException(x);
        }
        NetbeansActionMapping existing = null;
        for (NetbeansActionMapping m : mapping.getActions()) {
            if (!m.getActionName().equals(mapp.getActionName())) continue;
            existing = m;
            break;
        }
        if (existing != null) {
            mapping.getActions().set(mapping.getActions().indexOf(existing), mapp);
        } else {
            mapping.addAction(mapp);
        }
        CustomizerProviderImpl.writeNbActionsModel(project, mapping, M2Configuration.getFileNameExt(cfg.getId()));
    }

    List<String> getAllActions() {
        return this.allActions;
    }

    static {
        AccessorImpl impl = new AccessorImpl();
        impl.assign();
    }

    public static class Configuration {
        private String id;
        private String displayName;
        private boolean profileBased = false;
        private boolean defaul = false;
        private List<String> activatedProfiles;
        private Map<String, String> properties;
        private boolean shared = false;

        Configuration() {
        }

        public String getFileNameExt() {
            return M2Configuration.getFileNameExt(this.id);
        }

        public boolean isDefault() {
            return this.defaul && "%%DEFAULT%%".equals(this.id);
        }

        public boolean isProvided() {
            return this.defaul;
        }

        public void setDisplayName(String dn) {
            this.displayName = dn;
        }

        public void setDefault(boolean def) {
            this.defaul = def;
        }

        public List<String> getActivatedProfiles() {
            return this.activatedProfiles;
        }

        public void setActivatedProfiles(List<String> activatedProfiles) {
            this.activatedProfiles = activatedProfiles;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public String getDisplayName() {
            String n;
            String string = n = this.displayName == null ? this.id : this.displayName;
            if (this.isDefault()) {
                return Bundle.DefaultConfig();
            }
            if (this.isProfileBased()) {
                return Bundle.ProfileConfig(n);
            }
            if (this.isProvided()) {
                return Bundle.ProvidedConfig(n);
            }
            if (this.getActivatedProfiles() != null && this.getActivatedProfiles().size() > 0) {
                return Bundle.CustomConfig1(n, Arrays.toString(this.getActivatedProfiles().toArray()));
            }
            return Bundle.CustomConfig2(n);
        }

        public String getId() {
            return this.id;
        }

        public void setShared(boolean shared) {
            this.shared = shared;
        }

        public boolean isShared() {
            return this.shared;
        }

        void setId(String id) {
            this.id = id;
        }

        public boolean isProfileBased() {
            return this.profileBased;
        }

        void setProfileBased(boolean profileBased) {
            this.profileBased = profileBased;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    static class AccessorImpl
    extends CustomizerProviderImpl.ModelAccessor2 {
        AccessorImpl() {
        }

        @Override
        public ModelHandle2 createHandle(POMModel model, MavenProject proj, Map<String, ActionToGoalMapping> mapp, List<Configuration> configs, Configuration active, List<String> allActions, MavenProjectPropsImpl auxProps) {
            return new ModelHandle2(model, proj, mapp, configs, active, allActions, auxProps);
        }

        public void assign() {
            if (CustomizerProviderImpl.ACCESSOR2 == null) {
                CustomizerProviderImpl.ACCESSOR2 = this;
            }
        }

        @Override
        public List<String> getAllActions(ModelHandle2 handle) {
            return handle.getAllActions();
        }

        @Override
        public TreeMap<String, String> getModifiedAuxProps(ModelHandle2 handle, boolean shared) {
            return handle.getModifiedAuxProps(shared);
        }

        @Override
        public boolean isConfigurationModified(ModelHandle2 handle) {
            return handle.modConfig;
        }

        @Override
        public boolean isModified(ModelHandle2 handle, ActionToGoalMapping mapp) {
            return handle.modifiedMappings.contains(mapp);
        }
    }
}

