/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.netbeans.modules.maven.actions.CreateLibraryAction;
import org.netbeans.modules.maven.actions.ViewJavadocAction;
import org.netbeans.modules.maven.actions.scm.CheckoutAction;
import org.netbeans.modules.maven.actions.usages.FindArtifactUsages;
import org.netbeans.modules.maven.api.Bundle;
import org.netbeans.modules.maven.indexer.api.ui.ArtifactViewer;
import org.openide.util.Lookup;

public class CommonArtifactActions {
    private CommonArtifactActions() {
    }

    public static Action createViewJavadocAction(Artifact artifact) {
        return new ViewJavadocAction(artifact);
    }

    public static Action createFindUsages(Artifact artifact) {
        return new FindArtifactUsages(artifact);
    }

    public static Action createViewArtifactDetails(Artifact art, List<ArtifactRepository> remoteRepos) {
        return new ShowArtifactAction(art, remoteRepos);
    }

    public static Action createScmCheckoutAction(Lookup lkp) {
        return new CheckoutAction(lkp);
    }

    public static Action createLibraryAction(Lookup lkp) {
        return new CreateLibraryAction(lkp);
    }

    private static class ShowArtifactAction
    extends AbstractAction {
        private Artifact artifact;
        private List<ArtifactRepository> repos;

        ShowArtifactAction(Artifact art, List<ArtifactRepository> repos) {
            this.artifact = art;
            this.repos = repos;
            this.putValue("Name", Bundle.ACT_View_Details());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String hint = (String)this.getValue("PANEL_HINT");
            ArtifactViewer.showArtifactViewer((Artifact)this.artifact, this.repos, (String)hint);
        }
    }
}

