/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.actions.Bundle;
import org.netbeans.spi.project.ActionProvider;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class RunCustomMavenAction
extends AbstractAction
implements ContextAwareAction {
    static final String CATEGORY = "Project";
    static final String ID = "org.netbeans.modules.maven.actions.runcustom";
    public static final String MAVEN_ATTR = "maven-goal";
    private NbMavenProjectImpl prj;
    private final String action;
    private FileObject[] fos;

    public RunCustomMavenAction(String action) {
        this.setEnabled(false);
        this.action = action;
    }

    public RunCustomMavenAction(String action, NbMavenProjectImpl prj, FileObject[] fos) {
        this.action = action;
        this.prj = prj;
        this.fos = fos;
        this.setEnabled(((ActionProvider)prj.getLookup().lookup(ActionProvider.class)).isActionEnabled(action, Lookups.fixed((Object[])new Object[]{fos})));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.prj != null) {
            ((ActionProvider)this.prj.getLookup().lookup(ActionProvider.class)).invokeAction(this.action, Lookups.fixed((Object[])new Object[]{this.fos}));
        } else {
            Action act = this.createContextAwareInstance(Utilities.actionsGlobalContext());
            if (act != this) {
                act.actionPerformed(e);
            }
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        NbMavenProjectImpl owner = null;
        ArrayList<FileObject> fs = new ArrayList<FileObject>();
        for (FileObject fo : actionContext.lookupAll(FileObject.class)) {
            Project p = FileOwnerQuery.getOwner((FileObject)fo);
            if (p != null) {
                NbMavenProjectImpl own = (NbMavenProjectImpl)p.getLookup().lookup(NbMavenProjectImpl.class);
                if (own != null) {
                    if (owner != null) {
                        if (!owner.equals(own)) {
                            return this;
                        }
                    } else {
                        owner = own;
                    }
                    fs.add(fo);
                    continue;
                }
                if (owner == null) continue;
                return this;
            }
            if (owner == null) continue;
            return this;
        }
        if (owner != null) {
            return new RunCustomMavenAction(this.action, owner, fs.toArray(new FileObject[0]));
        }
        return this;
    }

    public static Action create(FileObject fo) {
        String mapp = (String)fo.getAttribute(MAVEN_ATTR);
        assert (mapp != null);
        String imagePath = (String)fo.getAttribute("imagePath");
        assert (imagePath != null);
        RunCustomMavenAction act = new RunCustomMavenAction(mapp);
        String name = mapp;
        if (name.startsWith("CUSTOM-")) {
            name = name.substring("CUSTOM-".length());
        }
        return Actions.context(FileObject.class, (boolean)true, (boolean)true, (ContextAwareAction)act, (String)ID, (String)Bundle.BTN_run_custom(name), (String)imagePath, (boolean)true);
    }

    public static void createActionDeclaration(String action, String displayName, String iconPath) throws IOException {
        String fsAction = action.replace("/", "");
        FileObject root = FileUtil.getConfigRoot();
        FileObject actions = root.getFileObject("Actions");
        if (actions == null) {
            actions = root.createFolder("Actions");
        }
        assert (actions != null);
        FileObject mavenCategory = actions.getFileObject("Maven");
        if (mavenCategory == null) {
            mavenCategory = actions.createFolder("Maven");
        }
        assert (mavenCategory != null);
        String name = fsAction + ".instance";
        FileObject instance = mavenCategory.getFileObject(name);
        if (instance != null) {
            return;
        }
        FileObject template = root.getFileObject("Maven/actionTemplate.instance");
        assert (template != null);
        instance = template.copy(mavenCategory, fsAction, "instance");
        instance.setAttribute(MAVEN_ATTR, (Object)action);
        assert (iconPath != null);
        instance.setAttribute("imagePath", (Object)iconPath);
        FileObject tb = root.getFileObject("Toolbars/Build");
        if (tb != null) {
            FileObject shadow = tb.createData("maven_" + fsAction + ".shadow");
            shadow.setAttribute("originalFile", (Object)("Actions/Maven/" + name));
            shadow.setAttribute("position", (Object)3002);
        }
    }

    public static void deleteDeclaration(String action) throws IOException {
        String fsAction = action.replace("/", "");
        FileObject root = FileUtil.getConfigRoot();
        FileObject fo = root.getFileObject("Toolbars/Build/maven_" + fsAction + ".shadow");
        if (fo != null) {
            fo.delete();
        }
        if ((fo = root.getFileObject("Actions/Maven/" + fsAction + ".instance")) != null) {
            fo.delete();
        }
    }

    public static boolean actionDeclarationExists(String action) {
        String name;
        FileObject instance;
        FileObject mavenCategory;
        String fsAction = action.replace("/", "");
        FileObject root = FileUtil.getConfigRoot();
        FileObject actions = root.getFileObject("Actions");
        return actions != null && (mavenCategory = actions.getFileObject("Maven")) != null && (instance = mavenCategory.getFileObject(name = fsAction + ".instance")) != null && action.equals(instance.getAttribute(MAVEN_ATTR));
    }

    public static String actionDeclarationIconPath(String action) {
        String name;
        FileObject instance;
        FileObject mavenCategory;
        String fsAction = action.replace("/", "");
        FileObject root = FileUtil.getConfigRoot();
        FileObject actions = root.getFileObject("Actions");
        if (actions != null && (mavenCategory = actions.getFileObject("Maven")) != null && (instance = mavenCategory.getFileObject(name = fsAction + ".instance")) != null && action.equals(instance.getAttribute(MAVEN_ATTR))) {
            String path = (String)instance.getAttribute("imagePath");
            return path;
        }
        return null;
    }

    public static Icon actionDeclarationIcon(String action) {
        String s = RunCustomMavenAction.actionDeclarationIconPath(action);
        if (s != null) {
            return ImageUtilities.loadImageIcon((String)s, (boolean)false);
        }
        return null;
    }

    public static List<String> createAllActionIcons() {
        ArrayList<String> allImages = new ArrayList<String>(Arrays.asList("org/netbeans/modules/maven/resources/Maven2IconRun1.png", "org/netbeans/modules/maven/resources/Maven2IconRun2.png", "org/netbeans/modules/maven/resources/Maven2IconRun3.png", "org/netbeans/modules/maven/resources/Maven2IconRun4.png", "org/netbeans/modules/maven/resources/Maven2IconRun5.png", "org/netbeans/modules/maven/resources/Maven2IconRun6.png"));
        return allImages;
    }
}

