/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.vcs.HookImpl;
import org.netbeans.modules.bugtracking.vcs.VCSHooksConfig;
import org.netbeans.modules.versioning.hooks.HgHook;
import org.netbeans.modules.versioning.hooks.HgHookContext;
import org.openide.util.NbBundle;

public class HgHookImpl
extends HgHook {
    private static final String[] SUPPORTED_ISSUE_INFO_VARIABLES = new String[]{"id", "summary"};
    private static final String[] SUPPORTED_REVISION_VARIABLES = new String[]{"changeset", "author", "date", "message"};
    private final String name = NbBundle.getMessage(HgHookImpl.class, (String)"LBL_VCSHook");
    private HookImpl delegate;

    public HgHookImpl() {
        VCSHooksConfig config = VCSHooksConfig.getInstance(VCSHooksConfig.HookType.HG);
        this.delegate = new HookImpl(config, SUPPORTED_ISSUE_INFO_VARIABLES, SUPPORTED_REVISION_VARIABLES);
    }

    public HgHookContext beforeCommit(HgHookContext context) throws IOException {
        String msg = this.delegate.beforeCommit(context.getFiles(), context.getMessage());
        return msg != null ? new HgHookContext(context.getFiles(), msg, context.getLogEntries()) : null;
    }

    public void afterCommit(HgHookContext context) {
        String author = context.getLogEntries()[0].getAuthor();
        String changeset = context.getLogEntries()[0].getChangeset();
        Date date = context.getLogEntries()[0].getDate();
        String message = context.getMessage();
        this.delegate.afterCommit(context.getFiles(), author, changeset, date, message, "HG", true);
    }

    public HgHookContext beforePush(HgHookContext context) throws IOException {
        return super.beforePush(context);
    }

    public void afterPush(HgHookContext context) {
        HgHookContext.LogEntry[] logEntries = context.getLogEntries();
        String[] changesets = new String[logEntries.length];
        for (int i = 0; i < logEntries.length; ++i) {
            HgHookContext.LogEntry logEntry = logEntries[i];
            changesets[i] = logEntry.getChangeset();
        }
        this.delegate.afterPush(context.getFiles(), changesets, "HG");
    }

    public void afterCommitReplace(HgHookContext originalContext, HgHookContext newContext, Map<String, String> mapping) {
        this.delegate.afterChangesetReplace(newContext.getFiles(), mapping, "HG");
    }

    public JPanel createComponent(HgHookContext context) {
        return this.delegate.createComponent(context.getFiles());
    }

    public String getDisplayName() {
        return this.name;
    }
}

