/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.openide.util.Utilities;

public abstract class LinkLabel
extends JLabel
implements MouseListener {
    private static final Color FOREGROUND_COLOR = UIManager.getColor("Label.foreground");
    private static final Color FOREGROUND_FOCUS_COLOR = UIManager.getColor("nb.html.link.foreground") != null ? UIManager.getColor("nb.html.link.foreground") : new Color(1461115);
    private final Icon icon;
    private Action[] popupActions = new Action[0];

    public LinkLabel(String text, Icon icon) {
        this.icon = icon;
        if (!text.isEmpty()) {
            this.setText(text);
        }
        this.init();
    }

    private void init() {
        if (this.icon != null) {
            this.setIcon(this.icon);
        }
        this.setForeground(FOREGROUND_COLOR);
        this.addMouseListener(this);
    }

    public void setPopupActions(Action ... popupActions) {
        this.popupActions = popupActions;
    }

    @Override
    public abstract void mouseClicked(MouseEvent var1);

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e.getPoint());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setForeground(FOREGROUND_FOCUS_COLOR);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setForeground(FOREGROUND_COLOR);
    }

    private void showPopup(Point p) {
        if (this.popupActions.length > 0) {
            JPopupMenu menu = Utilities.actionsToPopup((Action[])this.popupActions, (Component)this);
            menu.show(this, p.x, p.y);
        }
    }
}

