/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import javax.swing.Box;
import javax.swing.JComponent;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridInfoProvider;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridManager;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;

public class GridUtils {
    private static final String PADDING_COMPONENT = "dummyComponent";
    public static final int PADDING_SIZE_STANDARD = 20;
    public static final int PADDING_SIZE_MINIMAL = 4;

    public static boolean isPaddingComponent(Component comp) {
        boolean padding = false;
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            padding = jcomp.getClientProperty(PADDING_COMPONENT) != null;
        }
        return padding;
    }

    public static void removePaddingComponents(GridManager manager) {
        Container cont = manager.getContainer();
        for (Component comp : cont.getComponents()) {
            if (!GridUtils.isPaddingComponent(comp)) continue;
            manager.removeComponent(comp);
        }
    }

    public static void addPaddingComponents(GridManager manager, int columnNo, int rowNo) {
        manager.updateLayout(false);
        boolean shouldPad = FormLoaderSettings.getInstance().getPadEmptyCells();
        if (!shouldPad) {
            return;
        }
        GridInfoProvider info = manager.getGridInfo();
        Container container = manager.getContainer();
        if (container.getComponentCount() == 0) {
            Component padding = GridUtils.createPaddingComponent(true, true);
            manager.addComponent(padding, 0, 0, 1, 1);
        }
        columnNo = Math.max(Math.max(columnNo, 1), info.getLastGapColumn() + 1);
        rowNo = Math.max(Math.max(rowNo, 1), info.getLastGapRow() + 1);
        boolean[] paddedColumn = new boolean[columnNo];
        boolean[] paddedRow = new boolean[rowNo];
        if (container.getLayout() instanceof GridBagLayout) {
            GridUtils.revalidateGrid(manager);
            for (Component comp : container.getComponents()) {
                Dimension prefSize;
                Dimension minSize;
                if (GridUtils.isPaddingComponent(comp)) continue;
                Dimension dim = comp.getSize();
                if (dim.width == 0) {
                    minSize = comp.getMinimumSize();
                    prefSize = comp.getPreferredSize();
                    if (prefSize.width == 0) {
                        comp.setMinimumSize(new Dimension(4, minSize.height));
                        comp.setPreferredSize(new Dimension(4, prefSize.height));
                    }
                }
                if (dim.height != 0) continue;
                minSize = comp.getMinimumSize();
                prefSize = comp.getPreferredSize();
                if (prefSize.height != 0) continue;
                comp.setMinimumSize(new Dimension(minSize.width, 4));
                comp.setPreferredSize(new Dimension(prefSize.width, 4));
            }
        }
        int gapWidth = FormLoaderSettings.getInstance().getGapWidth();
        int gapHeight = FormLoaderSettings.getInstance().getGapHeight();
        if (info.hasGaps()) {
            int gappedColumns = info.getLastGapColumn() > 0 ? info.getLastGapColumn() + 1 : 1;
            columnNo = columnNo > gappedColumns ? gappedColumns : columnNo;
            int gappedRows = info.getLastGapRow() > 0 ? info.getLastGapRow() + 1 : 1;
            rowNo = rowNo > gappedRows ? gappedRows : rowNo;
        }
        boolean modified = true;
        while (modified) {
            Component padding;
            int i;
            modified = false;
            GridUtils.revalidateGrid(manager);
            int[] columnBounds = info.getColumnBounds();
            int[] rowBounds = info.getRowBounds();
            for (i = 0; i < columnNo; ++i) {
                if (paddedColumn[i]) continue;
                if (info.isGapColumn(i)) {
                    padding = GridUtils.createPaddingComponent(true, false, gapWidth);
                    manager.addComponent(padding, i, 0, 1, 1);
                    paddedColumn[i] = true;
                    modified = true;
                    continue;
                }
                if (i < columnBounds.length - 1 && columnBounds[i] + 4 < columnBounds[i + 1]) continue;
                padding = GridUtils.createPaddingComponent(true, false);
                manager.addComponent(padding, i, 0, 1, 1);
                paddedColumn[i] = true;
                modified = true;
            }
            for (i = 0; i < rowNo; ++i) {
                if (paddedRow[i]) continue;
                if (info.isGapRow(i)) {
                    padding = GridUtils.createPaddingComponent(false, true, gapHeight);
                    manager.addComponent(padding, 0, i, 1, 1);
                    paddedRow[i] = true;
                    modified = true;
                    continue;
                }
                if (i < rowBounds.length - 1 && rowBounds[i] + 4 < rowBounds[i + 1]) continue;
                padding = GridUtils.createPaddingComponent(false, true);
                manager.addComponent(padding, 0, i, 1, 1);
                paddedRow[i] = true;
                modified = true;
            }
        }
    }

    private static Component createPaddingComponent(boolean horizontalPadding, boolean verticalPadding) {
        return GridUtils.createPaddingComponent(horizontalPadding, verticalPadding, 20);
    }

    private static Component createPaddingComponent(boolean horizontalPadding, boolean verticalPadding, int paddingSize) {
        Dimension dim = new Dimension(horizontalPadding ? paddingSize : 0, verticalPadding ? paddingSize : 0);
        JComponent padding = (JComponent)Box.createRigidArea(dim);
        padding.putClientProperty(PADDING_COMPONENT, Boolean.TRUE);
        return padding;
    }

    public static void revalidateGrid(GridManager manager) {
        Container cont = manager.getContainer();
        Container parent = cont.getParent();
        parent.invalidate();
        parent.doLayout();
        cont.invalidate();
        cont.doLayout();
    }

    public static BufferedImage loadBufferedImage(String resource, boolean localized) {
        BufferedImage rep;
        Image image = ImageUtilities.loadImage((String)resource, (boolean)localized);
        if (image == null) {
            return null;
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (Utilities.isMac()) {
            rep = new BufferedImage(width, height, 3);
        } else {
            ColorModel model;
            try {
                model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(3);
            }
            catch (HeadlessException he) {
                model = ColorModel.getRGBdefault();
            }
            rep = new BufferedImage(model, model.createCompatibleWritableRaster(width, height), model.isAlphaPremultiplied(), null);
        }
        Graphics2D g = rep.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return rep;
    }
}

