/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ListSelector
extends JPanel {
    private JButton addAllButton;
    private JButton addButton;
    private JLabel availableLabel;
    private JList availableList;
    private JScrollPane availableScrollPane;
    private JButton downButton;
    private JButton removeAllButton;
    private JButton removeButton;
    private JLabel selectedLabel;
    private JList selectedList;
    private JScrollPane selectedScrollPane;
    private JButton upButton;

    public ListSelector() {
        this.initComponents();
        ListDataListener listener = new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (e.getSource() == ListSelector.this.availableList.getModel()) {
                    ListSelector.this.addAllButton.setEnabled(ListSelector.this.availableList.getModel().getSize() != 0);
                } else if (e.getSource() == ListSelector.this.selectedList.getModel()) {
                    ListSelector.this.removeAllButton.setEnabled(ListSelector.this.selectedList.getModel().getSize() != 0);
                }
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.contentsChanged(e);
            }
        };
        this.availableList.getModel().addListDataListener(listener);
        this.selectedList.getModel().addListDataListener(listener);
    }

    public void setItems(List available, List selected) {
        DefaultListModel model = (DefaultListModel)this.availableList.getModel();
        model.clear();
        for (Object item : available) {
            model.addElement(item);
        }
        model = (DefaultListModel)this.selectedList.getModel();
        model.clear();
        for (Object item : selected) {
            model.addElement(item);
        }
    }

    public List getSelectedItems() {
        DefaultListModel model = (DefaultListModel)this.selectedList.getModel();
        return Arrays.asList(model.toArray());
    }

    private void initComponents() {
        this.availableLabel = new JLabel();
        this.availableScrollPane = new JScrollPane();
        this.availableList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.addAllButton = new JButton();
        this.removeAllButton = new JButton();
        this.selectedScrollPane = new JScrollPane();
        this.selectedList = new JList();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.selectedLabel = new JLabel();
        this.availableLabel.setLabelFor(this.availableList);
        Mnemonics.setLocalizedText((JLabel)this.availableLabel, (String)NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Available"));
        this.availableList.setModel(new DefaultListModel());
        this.availableList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ListSelector.this.availableListValueChanged(evt);
            }
        });
        this.availableScrollPane.setViewportView(this.availableList);
        this.availableList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Available_ACSN"));
        this.availableList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Available_ACSD"));
        this.addButton.setText(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Add"));
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListSelector.this.addButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListSelector.this.removeButtonActionPerformed(evt);
            }
        });
        this.addAllButton.setText(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_AddAll"));
        this.addAllButton.setEnabled(false);
        this.addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListSelector.this.addAllButtonActionPerformed(evt);
            }
        });
        this.removeAllButton.setText(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_RemoveAll"));
        this.removeAllButton.setEnabled(false);
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListSelector.this.removeAllButtonActionPerformed(evt);
            }
        });
        this.selectedList.setModel(new DefaultListModel());
        this.selectedList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ListSelector.this.selectedListValueChanged(evt);
            }
        });
        this.selectedScrollPane.setViewportView(this.selectedList);
        this.selectedList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Selected_ACSN"));
        this.selectedList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Selected_ACSD"));
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/resources/up.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Up"));
        this.upButton.setEnabled(false);
        this.upButton.setHorizontalAlignment(10);
        if (!Utilities.isMac()) {
            this.upButton.setMargin(new Insets(2, 6, 2, 6));
        }
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListSelector.this.upButtonActionPerformed(evt);
            }
        });
        this.downButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/resources/down.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Down"));
        this.downButton.setEnabled(false);
        this.downButton.setHorizontalAlignment(10);
        if (!Utilities.isMac()) {
            this.downButton.setMargin(new Insets(2, 6, 2, 6));
        }
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListSelector.this.downButtonActionPerformed(evt);
            }
        });
        this.selectedLabel.setLabelFor(this.selectedList);
        Mnemonics.setLocalizedText((JLabel)this.selectedLabel, (String)NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Selected"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.availableLabel).addComponent(this.availableScrollPane, -1, 207, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.addButton, -1, -1, Short.MAX_VALUE).addComponent(this.removeButton, -1, -1, Short.MAX_VALUE).addComponent(this.addAllButton, -1, -1, Short.MAX_VALUE).addComponent(this.removeAllButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectedScrollPane, -1, 207, Short.MAX_VALUE).addComponent(this.selectedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.downButton, -1, -1, Short.MAX_VALUE).addComponent(this.upButton, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.availableLabel).addComponent(this.selectedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 37, Short.MAX_VALUE).addComponent(this.upButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton).addContainerGap(46, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 6, Short.MAX_VALUE).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeAllButton).addContainerGap(17, Short.MAX_VALUE)).addComponent(this.availableScrollPane, -1, 141, Short.MAX_VALUE).addComponent(this.selectedScrollPane, -1, 141, Short.MAX_VALUE))));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Add_ACSD"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Remove_ACSD"));
        this.addAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_AddAll_ACSD"));
        this.removeAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_RemoveAll_ACSD"));
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Up_ACSD"));
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListSelector.class, (String)"MSG_ListSelector_Down_ACSD"));
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.selectedList.getModel();
        int index = this.selectedList.getSelectedIndex();
        Object item = model.remove(index);
        model.add(index + 1, item);
        this.selectedList.setSelectedIndex(index + 1);
        this.selectedList.ensureIndexIsVisible(index + 1);
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.selectedList.getModel();
        int index = this.selectedList.getSelectedIndex();
        Object item = model.remove(index);
        model.add(index - 1, item);
        this.selectedList.setSelectedIndex(index - 1);
        this.selectedList.ensureIndexIsVisible(index - 1);
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        ListSelector.moveListItems(this.selectedList, this.availableList, false);
    }

    private void addAllButtonActionPerformed(ActionEvent evt) {
        ListSelector.moveListItems(this.availableList, this.selectedList, false);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        ListSelector.moveListItems(this.selectedList, this.availableList, true);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        ListSelector.moveListItems(this.availableList, this.selectedList, true);
    }

    private void selectedListValueChanged(ListSelectionEvent evt) {
        this.removeButton.setEnabled(this.selectedList.getSelectedIndex() != -1);
        int[] index = this.selectedList.getSelectedIndices();
        this.upButton.setEnabled(index.length == 1 && index[0] != 0);
        this.downButton.setEnabled(index.length == 1 && index[0] != this.selectedList.getModel().getSize() - 1);
    }

    private void availableListValueChanged(ListSelectionEvent evt) {
        this.addButton.setEnabled(this.availableList.getSelectedIndex() != -1);
    }

    private static void moveListItems(JList fromList, JList toList, boolean selected) {
        DefaultListModel fromModel = (DefaultListModel)fromList.getModel();
        DefaultListModel toModel = (DefaultListModel)toList.getModel();
        if (selected) {
            int i;
            int[] index = fromList.getSelectedIndices();
            for (i = 0; i < index.length; ++i) {
                Object item = fromModel.getElementAt(index[i]);
                toModel.addElement(item);
            }
            for (i = index.length - 1; i >= 0; --i) {
                fromModel.removeElementAt(index[i]);
            }
        } else {
            Enumeration items = fromModel.elements();
            while (items.hasMoreElements()) {
                toModel.addElement(items.nextElement());
            }
            fromModel.clear();
        }
    }
}

