/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.hints;

import com.sun.source.util.TreePath;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.MessageImpl;
import org.netbeans.modules.java.hints.spiimpl.SPIAccessor;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.Hint;

public class HintContext {
    private final CompilationInfo info;
    private final HintsSettings settings;
    private final Preferences preferences;
    private final Severity severity;
    private final HintMetadata metadata;
    private final TreePath path;
    private final Map<String, TreePath> variables;
    private final Map<String, Collection<? extends TreePath>> multiVariables;
    private final Map<String, String> variableNames;
    private final Collection<? super MessageImpl> messages;
    private final Map<String, TypeMirror> constraints;
    private final boolean bulkMode;
    private final AtomicBoolean cancel;
    private final int caret;

    private HintContext(CompilationInfo info, HintsSettings settings, HintMetadata metadata, TreePath path, Map<String, TreePath> variables, Map<String, Collection<? extends TreePath>> multiVariables, Map<String, String> variableNames, Map<String, TypeMirror> constraints, Collection<? super MessageImpl> problems, boolean bulkMode, AtomicBoolean cancel, int caret) {
        this.info = info;
        this.settings = settings;
        this.preferences = metadata != null ? settings.getHintPreferences(metadata) : null;
        this.severity = this.preferences != null ? settings.getSeverity(metadata) : Severity.ERROR;
        this.metadata = metadata;
        this.path = path;
        variables = new HashMap<String, TreePath>(variables);
        variables.put("$_", path);
        this.variables = variables;
        this.multiVariables = multiVariables;
        this.variableNames = variableNames;
        this.messages = problems;
        this.constraints = constraints;
        this.bulkMode = bulkMode;
        this.cancel = cancel;
        this.caret = caret;
    }

    public CompilationInfo getInfo() {
        return this.info;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public TreePath getPath() {
        return this.path;
    }

    public Map<String, TreePath> getVariables() {
        return this.variables;
    }

    public Map<String, Collection<? extends TreePath>> getMultiVariables() {
        return this.multiVariables;
    }

    public Map<String, String> getVariableNames() {
        return this.variableNames;
    }

    HintMetadata getHintMetadata() {
        return this.metadata;
    }

    public Map<String, TypeMirror> getConstraints() {
        return this.constraints;
    }

    public void reportMessage(MessageKind kind, String text) {
        this.messages.add(new MessageImpl(kind, text));
    }

    public boolean isBulkMode() {
        return this.bulkMode;
    }

    public boolean isCanceled() {
        return this.cancel.get();
    }

    public int getCaretLocation() {
        return this.metadata.kind == Hint.Kind.ACTION ? this.caret : -1;
    }

    static {
        SPIAccessor.setINSTANCE(new SPIAccessor(){

            @Override
            public HintContext createHintContext(CompilationInfo info, HintsSettings settings, HintMetadata metadata, TreePath path, Map<String, TreePath> variables, Map<String, Collection<? extends TreePath>> multiVariables, Map<String, String> variableNames, Map<String, TypeMirror> constraints, Collection<? super MessageImpl> problems, boolean bulkMode, AtomicBoolean cancel, int caret) {
                return new HintContext(info, settings, metadata, path, variables, multiVariables, variableNames, constraints, problems, bulkMode, cancel, caret);
            }

            @Override
            public HintContext createHintContext(CompilationInfo info, HintsSettings settings, HintMetadata metadata, TreePath path, Map<String, TreePath> variables, Map<String, Collection<? extends TreePath>> multiVariables, Map<String, String> variableNames) {
                return new HintContext(info, settings, metadata, path, variables, multiVariables, variableNames, Collections.emptyMap(), new LinkedList(), false, new AtomicBoolean(), -1);
            }

            @Override
            public HintMetadata getHintMetadata(HintContext ctx) {
                return ctx.getHintMetadata();
            }

            @Override
            public HintsSettings getHintSettings(HintContext ctx) {
                return ctx.settings;
            }
        });
    }

    public static enum MessageKind {
        WARNING,
        ERROR;

    }
}

