/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle;

import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cloud.oracle.CloudChildFactory;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCISessionInitiator;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class OCINode
extends AbstractNode {
    private RefreshListener refreshListener;
    private final OCIItem item;
    private final CloudChildFactory factory;
    private final OCISessionInitiator session;

    public OCINode(OCIItem item) {
        this(new CloudChildFactory(item), item, OCIManager.getDefault().getActiveSession(), Lookups.fixed((Object[])new Object[]{item}));
    }

    public OCINode(OCIItem item, OCISessionInitiator session) {
        this(new CloudChildFactory(session, item), item, session, Lookups.fixed((Object[])new Object[]{item, session}));
    }

    private OCINode(CloudChildFactory factory, OCIItem item, OCISessionInitiator session, Lookup lookup) {
        super(Children.create((ChildFactory)factory, (boolean)true), lookup);
        this.setName(item.getName());
        this.item = item;
        this.factory = factory;
        this.session = session;
        this.refreshListener = new RefreshListener();
        item.addChangeListener(this.refreshListener);
    }

    public OCINode(OCIItem item, Children children) {
        super(children, Lookups.fixed((Object[])new Object[]{item, OCIManager.getDefault().getActiveSession()}));
        this.setName(item.getName());
        this.item = item;
        this.factory = null;
        this.session = OCIManager.getDefault().getActiveSession();
        this.refreshListener = new RefreshListener();
        item.addChangeListener(this.refreshListener);
    }

    protected BasicAuthenticationDetailsProvider getAuthProvider() {
        return this.session.getAuthenticationProvider();
    }

    public Action[] getActions(boolean context) {
        ArrayList<? extends Action> result = new ArrayList<Action>();
        List<? extends Action> commonActions = OCINode.actionsForPath("Cloud/Oracle/Common/Actions", this.getLookup());
        for (Action action : commonActions) {
            if (!action.isEnabled()) continue;
            result.add(action);
        }
        result.addAll(OCINode.actionsForPath(String.format("Cloud/Oracle/%s/Actions", this.item.getKey().getPath()), this.getLookup()));
        return result.toArray(new Action[0]);
    }

    public static final List<? extends Action> actionsForPath(String path, Lookup lkp) {
        List actions = Utilities.actionsForPath((String)path);
        ArrayList<Action> ret = new ArrayList<Action>(actions.size());
        for (Action a : actions) {
            if (a instanceof ContextAwareAction && (a = ((ContextAwareAction)a).createContextAwareInstance(lkp)) == null) continue;
            ret.add(a);
        }
        return ret;
    }

    public void refresh() {
        if (this.factory != null) {
            this.factory.refreshKeys();
        }
    }

    public Node.Handle getHandle() {
        return super.getHandle();
    }

    private final class RefreshListener
    implements ChangeListener {
        private RefreshListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            OCINode.this.refresh();
        }
    }
}

