/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.indent.spi.ReformatTask;
import org.netbeans.modules.lsp.client.bindings.Formatter;
import org.netbeans.modules.lsp.client.spi.LanguageServerProvider;
import org.netbeans.spi.editor.mimelookup.MimeDataProvider;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class LspMimeDataProvider
implements MimeDataProvider {
    private static final Formatter.Factory lspFormatter = new Formatter.Factory();
    private static final Lookup lspFormatterLookup = Lookups.fixed((Object[])new Object[]{lspFormatter});

    public Lookup getLookup(MimePath mimePath) {
        return new MimeLookupMonitoringLookup(mimePath);
    }

    private static class MimeLookupMonitoringLookup
    extends ProxyLookup
    implements LookupListener {
        private final AtomicBoolean initialized = new AtomicBoolean();
        private final Lookup.Result<LanguageServerProvider> lspResult;

        public MimeLookupMonitoringLookup(MimePath mimePath) {
            this.lspResult = MimeLookup.getLookup((MimePath)mimePath).lookupResult(LanguageServerProvider.class);
            this.lspResult.addLookupListener((LookupListener)this);
        }

        public void resultChanged(LookupEvent ev) {
            this.initialized.set(false);
        }

        protected void beforeLookup(Lookup.Template<?> template) {
            super.beforeLookup(template);
            Class clz = template.getType();
            if (ReformatTask.Factory.class.isAssignableFrom(clz) && !this.initialized.getAndSet(true)) {
                if (this.lspResult.allInstances().isEmpty()) {
                    this.setLookups(new Lookup[0]);
                } else {
                    this.setLookups(new Lookup[]{lspFormatterLookup});
                }
            }
        }
    }
}

