/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.htmlunit;

import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.util.Cookie;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.htmlunit.ForwardRequestPostProcessor;
import org.springframework.test.web.servlet.htmlunit.HtmlUnitRequestBuilder;
import org.springframework.test.web.servlet.htmlunit.MockWebResponseBuilder;
import org.springframework.util.Assert;

public final class MockMvcWebConnection
implements WebConnection {
    private final Map<String, MockHttpSession> sessions = new HashMap<String, MockHttpSession>();
    private final MockMvc mockMvc;
    private final String contextPath;
    private WebClient webClient;

    public MockMvcWebConnection(MockMvc mockMvc, WebClient webClient) {
        this(mockMvc, webClient, "");
    }

    public MockMvcWebConnection(MockMvc mockMvc, WebClient webClient, String contextPath) {
        Assert.notNull((Object)mockMvc, (String)"MockMvc must not be null");
        Assert.notNull((Object)webClient, (String)"WebClient must not be null");
        MockMvcWebConnection.validateContextPath(contextPath);
        this.webClient = webClient;
        this.mockMvc = mockMvc;
        this.contextPath = contextPath;
    }

    @Deprecated
    public MockMvcWebConnection(MockMvc mockMvc) {
        this(mockMvc, "");
    }

    @Deprecated
    public MockMvcWebConnection(MockMvc mockMvc, String contextPath) {
        this(mockMvc, new WebClient(), contextPath);
    }

    static void validateContextPath(String contextPath) {
        if (contextPath == null || "".equals(contextPath)) {
            return;
        }
        if (!contextPath.startsWith("/")) {
            throw new IllegalArgumentException("contextPath '" + contextPath + "' must start with '/'.");
        }
        if (contextPath.endsWith("/")) {
            throw new IllegalArgumentException("contextPath '" + contextPath + "' must not end with '/'.");
        }
    }

    public void setWebClient(WebClient webClient) {
        Assert.notNull((Object)webClient, (String)"WebClient must not be null");
        this.webClient = webClient;
    }

    public WebResponse getResponse(WebRequest webRequest) throws IOException {
        long startTime = System.currentTimeMillis();
        HtmlUnitRequestBuilder requestBuilder = new HtmlUnitRequestBuilder(this.sessions, this.webClient, webRequest);
        requestBuilder.setContextPath(this.contextPath);
        MockHttpServletResponse httpServletResponse = this.getResponse(requestBuilder);
        String forwardedUrl = httpServletResponse.getForwardedUrl();
        while (forwardedUrl != null) {
            requestBuilder.setForwardPostProcessor(new ForwardRequestPostProcessor(forwardedUrl));
            httpServletResponse = this.getResponse(requestBuilder);
            forwardedUrl = httpServletResponse.getForwardedUrl();
        }
        this.storeCookies(webRequest, httpServletResponse.getCookies());
        return new MockWebResponseBuilder(startTime, webRequest, httpServletResponse).build();
    }

    private MockHttpServletResponse getResponse(RequestBuilder requestBuilder) throws IOException {
        ResultActions resultActions;
        try {
            resultActions = this.mockMvc.perform(requestBuilder);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return resultActions.andReturn().getResponse();
    }

    private void storeCookies(WebRequest webRequest, javax.servlet.http.Cookie[] cookies) {
        if (cookies == null) {
            return;
        }
        Date now = new Date();
        CookieManager cookieManager = this.webClient.getCookieManager();
        for (javax.servlet.http.Cookie cookie : cookies) {
            Cookie toManage;
            Date expires;
            if (cookie.getDomain() == null) {
                cookie.setDomain(webRequest.getUrl().getHost());
            }
            if ((expires = (toManage = MockWebResponseBuilder.createCookie(cookie)).getExpires()) == null || expires.after(now)) {
                cookieManager.addCookie(toManage);
                continue;
            }
            cookieManager.removeCookie(toManage);
        }
    }

    public void close() {
    }
}

