/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ViewActions
extends AbstractAction {
    private String viewName;

    private ViewActions(String viewName) {
        this.viewName = viewName;
    }

    @Override
    public Object getValue(String key) {
        if (key == "Name") {
            return NbBundle.getMessage(ViewActions.class, (String)((String)super.getValue(key)));
        }
        Object value = super.getValue(key);
        return value;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        ViewActions.openComponent(this.viewName, true);
    }

    static TopComponent openComponent(String viewName, boolean activate) {
        TopComponent view = WindowManager.getDefault().findTopComponent(viewName);
        if (view == null) {
            throw new IllegalArgumentException(viewName);
        }
        view.open();
        if (activate) {
            view.requestActive();
        }
        return view;
    }

    public static Action createBreakpointsViewAction() {
        ViewActions action = new ViewActions("breakpointsView");
        action.putValue("Name", "CTL_BreakpointsAction");
        action.putValue("iconbase", "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoints.png");
        return action;
    }

    public static Action createCallStackViewAction() {
        ViewActions action = new ViewActions("callstackView");
        action.putValue("Name", "CTL_CallStackAction");
        action.putValue("iconbase", "org/netbeans/modules/debugger/resources/callStackView/call_stack_16.png");
        return action;
    }

    public static Action createLocalsViewAction() {
        ViewActions action = new ViewActions("localsView");
        action.putValue("Name", "CTL_LocalVariablesAction");
        action.putValue("iconbase", "org/netbeans/modules/debugger/resources/localsView/local_variable_16.png");
        return action;
    }

    public static Action createSessionsViewAction() {
        ViewActions action = new ViewActions("sessionsView");
        action.putValue("Name", "CTL_SessionsAction");
        action.putValue("iconbase", "org/netbeans/modules/debugger/resources/sessionsView/session_16.png");
        return action;
    }

    public static Action createThreadsViewAction() {
        ViewActions action = new ViewActions("threadsView");
        action.putValue("Name", "CTL_ThreadsAction");
        action.putValue("iconbase", "org/netbeans/modules/debugger/resources/threadsView/ThreadGroup.gif");
        return action;
    }

    public static Action createWatchesViewAction() {
        ViewActions action = new ViewActions("watchesView");
        action.putValue("Name", "CTL_WatchesAction");
        action.putValue("iconbase", "org/netbeans/modules/debugger/resources/watchesView/watch_16.png");
        return action;
    }

    public static Action createSourcesViewAction() {
        ViewActions action = new ViewActions("sources");
        action.putValue("Name", "CTL_SourcesAction");
        action.putValue("iconbase", "org/netbeans/modules/debugger/resources/sourcesView/sources_16.png");
        return action;
    }

    public static Action createDebuggingViewAction() {
        ViewActions action = new ViewActions("debuggingView");
        action.putValue("Name", "CTL_DebuggingViewAction");
        action.putValue("iconbase", "org/netbeans/modules/debugger/resources/debuggingView/debugging_16.png");
        return action;
    }
}

