/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.json.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.javascript2.json.spi.JsonOptionsQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public class JsonOptionsQuery {
    private JsonOptionsQuery() {
        throw new IllegalStateException("No instance allowed");
    }

    @NonNull
    public static Result getOptions(@NonNull FileObject file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        ArrayDeque<JsonOptionsQueryImplementation.Result> results = new ArrayDeque<JsonOptionsQueryImplementation.Result>();
        for (JsonOptionsQueryImplementation impl : Lookup.getDefault().lookupAll(JsonOptionsQueryImplementation.class)) {
            JsonOptionsQueryImplementation.Result res = impl.getOptions(file);
            if (res == null) continue;
            results.offer(res);
        }
        return new Result(results);
    }

    public static final class Result {
        public static final String PROP_COMMENT_SUPPORTED = "commentSupported";
        private final Collection<? extends JsonOptionsQueryImplementation.Result> delegates;
        private final PropertyChangeSupport listeners;
        private final PropertyChangeListener pcl;
        private final AtomicBoolean listens = new AtomicBoolean();

        private Result(@NonNull Collection<? extends JsonOptionsQueryImplementation.Result> delegates) {
            Parameters.notNull((CharSequence)"delegates", delegates);
            this.delegates = delegates;
            this.listeners = new PropertyChangeSupport(this);
            this.pcl = evt -> this.listeners.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }

        public boolean isCommentSupported() {
            for (JsonOptionsQueryImplementation.Result result : this.delegates) {
                Boolean res = result.isCommentSupported();
                if (res == null) continue;
                return res;
            }
            return false;
        }

        public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            if (!this.listens.get() && this.listens.compareAndSet(false, true)) {
                this.delegates.forEach(r -> r.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)r)));
            }
            this.listeners.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.listeners.removePropertyChangeListener(listener);
        }
    }
}

