/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.payara.tooling.admin.CommandException;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.logging.Logger;
import org.netbeans.modules.payara.tooling.utils.OsUtils;

public class PasswordFile {
    private static final Logger LOGGER = new Logger(PasswordFile.class);
    public static final String PASSWORD_FILE_NAME = "password-file";
    private static final Set<PosixFilePermission> CREATE_FILE_PERMISSIONS = new HashSet<PosixFilePermission>();
    private static final Set<PosixFilePermission> FINAL_FILE_PERMISSIONS;
    private static final char ASSIGN_VALUE = '=';
    private static final String AS_ADMIN_PASSWORD = "AS_ADMIN_PASSWORD";
    private static final String AS_ADMIN_MASTERPASSWORD = "AS_ADMIN_MASTERPASSWORD";
    private static final String AS_ADMIN_NEWPASSWORD = "AS_ADMIN_NEWPASSWORD";
    Path file;
    private String adminPassword;
    private String masterPassword;
    private String adminNewPassword;

    public static Path buildPasswordFilePath(PayaraServer server) {
        String METHOD = "buildPasswordFilePath";
        String domainsFolder = server.getDomainsFolder();
        String domainName = server.getDomainName();
        if (domainsFolder == null || domainName == null) {
            throw new CommandException(LOGGER.excMsg("buildPasswordFilePath", "nullValue"));
        }
        return Paths.get(domainsFolder, domainName, "config", PASSWORD_FILE_NAME);
    }

    PasswordFile(PayaraServer server) {
        this.file = PasswordFile.buildPasswordFilePath(server);
        this.adminPassword = server.getAdminPassword();
        this.masterPassword = null;
        this.adminNewPassword = null;
    }

    public String getFilePath() {
        return this.file.toString();
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getMasterPassword() {
        return this.masterPassword;
    }

    public void setMasterPassword(String masterPassword) {
        this.masterPassword = masterPassword;
    }

    public String getAdminNewPassword() {
        return this.adminNewPassword;
    }

    public void setAdminNewPassword(String adminNewPassword) {
        this.adminNewPassword = adminNewPassword;
    }

    private String dataToWrite() {
        int len = AS_ADMIN_PASSWORD.length() + 1 + this.adminPassword.length();
        if (this.masterPassword != null) {
            len += AS_ADMIN_MASTERPASSWORD.length() + 1 + this.masterPassword.length();
        }
        if (this.adminNewPassword != null) {
            len += AS_ADMIN_NEWPASSWORD.length() + 1 + this.adminNewPassword.length();
        }
        StringBuilder sb = new StringBuilder(len);
        sb.append(AS_ADMIN_PASSWORD).append('=');
        sb.append(this.adminPassword).append(OsUtils.LINES_SEPARATOR);
        if (this.masterPassword != null) {
            sb.append(AS_ADMIN_MASTERPASSWORD).append('=');
            sb.append(this.masterPassword).append(OsUtils.LINES_SEPARATOR);
        }
        if (this.adminNewPassword != null) {
            sb.append(AS_ADMIN_NEWPASSWORD).append('=');
            sb.append(this.adminNewPassword).append(OsUtils.LINES_SEPARATOR);
        }
        return sb.toString();
    }

    private boolean createFilePosix() {
        String METHOD = "createFilePosix";
        boolean success = false;
        try {
            if (Files.notExists(this.file, new LinkOption[0])) {
                Files.createFile(this.file, PosixFilePermissions.asFileAttribute(CREATE_FILE_PERMISSIONS));
                success = true;
            } else {
                Files.setPosixFilePermissions(this.file, CREATE_FILE_PERMISSIONS);
                LOGGER.log(Level.INFO, "createFilePosix", "exists", this.file.toString());
            }
        }
        catch (UnsupportedOperationException uoe) {
            LOGGER.log(Level.INFO, "createFilePosix", "unsupported", this.file.toString());
        }
        catch (FileAlreadyExistsException faee) {
            LOGGER.log(Level.INFO, "createFilePosix", "exists", this.file.toString());
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, "createFilePosix", "ioException", ioe);
        }
        return success;
    }

    private boolean finishFilePosix() {
        String METHOD = "finishFilePosix";
        boolean success = false;
        try {
            Files.setPosixFilePermissions(this.file, FINAL_FILE_PERMISSIONS);
            success = true;
        }
        catch (UnsupportedOperationException uoe) {
            LOGGER.log(Level.INFO, "finishFilePosix", "unsupported", this.file.toString());
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, "finishFilePosix", "ioException", ioe);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write() {
        String METHOD = "write";
        if (this.adminPassword == null) {
            this.adminPassword = "";
        }
        boolean success = true;
        Writer out = null;
        this.createFilePosix();
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file.toFile()), StandardCharsets.UTF_8);
            out.write(this.dataToWrite());
        }
        catch (IOException ioe) {
            success = false;
            LOGGER.log(Level.INFO, "write", "writeException", new Object[]{this.file.toString(), ioe.getMessage()});
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {
                    success = false;
                    LOGGER.log(Level.INFO, "write", "closeException", this.file.toString());
                }
                this.finishFilePosix();
            }
        }
        return success;
    }

    static {
        CREATE_FILE_PERMISSIONS.add(PosixFilePermission.OWNER_READ);
        CREATE_FILE_PERMISSIONS.add(PosixFilePermission.OWNER_WRITE);
        FINAL_FILE_PERMISSIONS = new HashSet<PosixFilePermission>();
        FINAL_FILE_PERMISSIONS.add(PosixFilePermission.OWNER_READ);
    }
}

