/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.analyzer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.php.analysis.commands.CodingStandardsFixer;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.options.ValidatorCodingStandardsFixerParameter;
import org.netbeans.modules.php.analysis.ui.AnalysisDefaultDocumentListener;
import org.netbeans.modules.php.analysis.ui.analyzer.PHPStanCustomizerPanel;
import org.netbeans.modules.php.analysis.util.AnalysisUiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CodingStandardsFixerCustomizerPanel
extends JPanel {
    private static final long serialVersionUID = -2799627803431340323L;
    public static final String ENABLED = "codingStandardsFixer.enabled";
    public static final String PATH = "codingStandardsFixer.path";
    public static final String VERSION = "codingStandardsFixer.version";
    public static final String LEVEL = "codingStandardsFixer.level";
    public static final String CONFIG = "codingStandardsFixer.config";
    public static final String OPTIONS = "codingStandardsFixer.options";
    private static final RequestProcessor RP = new RequestProcessor(PHPStanCustomizerPanel.class);
    final Analyzer.CustomizerContext<Void, CodingStandardsFixerCustomizerPanel> context;
    final Preferences settings;
    private JButton browseButton;
    private JTextField codingStandardsFixerTextField;
    private JLabel codingStandarsFixerLabel;
    private JComboBox<String> configComboBox;
    private JLabel configLabel;
    private JCheckBox enabledCheckBox;
    private JComboBox<String> levelComboBox;
    private JLabel levelLabel;
    private JLabel optionsLabel;
    private JTextField optionsTextField;
    private JButton searchButton;
    private JComboBox<String> versionComboBox;
    private JLabel versionLabel;

    public CodingStandardsFixerCustomizerPanel(Analyzer.CustomizerContext<Void, CodingStandardsFixerCustomizerPanel> context) {
        assert (EventQueue.isDispatchThread());
        assert (context != null);
        this.context = context;
        this.settings = context.getSettings();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.initEnabledCheckBox();
        this.initCodingStandardsFixerField();
        this.initVersionComboBox();
        this.initLevelComboBox();
        this.initConfigComboBox();
        this.initOptionsTextField();
        RP.schedule(() -> EventQueue.invokeLater(() -> {
            this.context.setError(null);
            if (this.enabledCheckBox.isSelected()) {
                this.validateData();
            }
        }), 1000L, TimeUnit.MILLISECONDS);
    }

    private void initEnabledCheckBox() {
        assert (EventQueue.isDispatchThread());
        this.enabledCheckBox.addItemListener(e -> {
            this.setAllComponetsEnabled(this.enabledCheckBox.isSelected());
            this.setCodingStandardsFixerEnabled();
        });
        boolean isEnabled = this.settings.getBoolean(ENABLED, false);
        this.enabledCheckBox.setSelected(isEnabled);
        this.setAllComponetsEnabled(isEnabled);
        this.enabledCheckBox.addItemListener(e -> {
            if (!this.enabledCheckBox.isSelected()) {
                this.context.setError(null);
            } else {
                this.validateData();
            }
        });
    }

    private void initCodingStandardsFixerField() {
        assert (EventQueue.isDispatchThread());
        this.codingStandardsFixerTextField.setText(this.settings.get(PATH, AnalysisOptions.getInstance().getCodingStandardsFixerPath()));
        this.codingStandardsFixerTextField.getDocument().addDocumentListener(new AnalysisDefaultDocumentListener(() -> this.setCodingStandardsFixerPath()));
    }

    private void initVersionComboBox() {
        assert (EventQueue.isDispatchThread());
        DefaultComboBoxModel versionComboBoxModel = new DefaultComboBoxModel();
        CodingStandardsFixer.VERSIONS.forEach(version -> versionComboBoxModel.addElement(version));
        this.versionComboBox.setModel(versionComboBoxModel);
        this.versionComboBox.addItemListener(e -> this.setVersion());
        versionComboBoxModel.setSelectedItem(this.settings.get(VERSION, AnalysisOptions.getInstance().getCodingStandardsFixerVersion()));
    }

    private void initLevelComboBox() {
        assert (EventQueue.isDispatchThread());
        DefaultComboBoxModel levelComboBoxModel = new DefaultComboBoxModel();
        CodingStandardsFixer.ALL_LEVEL.forEach(level -> levelComboBoxModel.addElement(level));
        levelComboBoxModel.setSelectedItem(this.settings.get(LEVEL, AnalysisOptions.getInstance().getCodingStandardsFixerLevel()));
        this.levelComboBox.setModel(levelComboBoxModel);
        this.levelComboBox.addItemListener(e -> this.setLevel());
    }

    private void initConfigComboBox() {
        assert (EventQueue.isDispatchThread());
        DefaultComboBoxModel configComboBoxModel = new DefaultComboBoxModel();
        CodingStandardsFixer.ALL_CONFIG.forEach(config -> configComboBoxModel.addElement(config));
        configComboBoxModel.setSelectedItem(this.settings.get(CONFIG, AnalysisOptions.getInstance().getCodingStandardsFixerConfig()));
        this.configComboBox.setModel(configComboBoxModel);
        this.configComboBox.addItemListener(e -> this.setConfig());
    }

    private void initOptionsTextField() {
        assert (EventQueue.isDispatchThread());
        this.optionsTextField.setText(this.settings.get(OPTIONS, AnalysisOptions.getInstance().getCodingStandardsFixerOptions()));
        this.optionsTextField.getDocument().addDocumentListener(new AnalysisDefaultDocumentListener(() -> this.setOptions()));
    }

    public String getCodingStandardsFixerPath() {
        return this.codingStandardsFixerTextField.getText().trim();
    }

    private void setCodingStandardsFixerEnabled() {
        this.settings.putBoolean(ENABLED, this.enabledCheckBox.isSelected());
    }

    private void setCodingStandardsFixerPath() {
        if (this.validateData()) {
            this.settings.put(PATH, this.getCodingStandardsFixerPath());
        }
    }

    private void setVersion() {
        this.settings.put(VERSION, (String)this.versionComboBox.getSelectedItem());
    }

    private void setLevel() {
        this.settings.put(LEVEL, (String)this.levelComboBox.getSelectedItem());
    }

    private void setConfig() {
        this.settings.put(CONFIG, (String)this.configComboBox.getSelectedItem());
    }

    private void setOptions() {
        this.settings.put(OPTIONS, this.optionsTextField.getText());
    }

    private void setVersion1ComponentsVisible(boolean isVisible) {
        for (Component component : this.getVersion1Components()) {
            component.setVisible(isVisible);
        }
    }

    private List<Component> getVersion1Components() {
        return Arrays.asList(this.levelLabel, this.levelComboBox, this.configLabel, this.configComboBox);
    }

    private boolean validateData() {
        ValidatorCodingStandardsFixerParameter param = ValidatorCodingStandardsFixerParameter.create(this);
        ValidationResult result = new AnalysisOptionsValidator().validateCodingStandardsFixer(param).getResult();
        if (result.hasErrors()) {
            this.context.setError(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            return false;
        }
        if (result.hasWarnings()) {
            this.context.setError(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            return false;
        }
        this.context.setError(null);
        return true;
    }

    private void setAllComponetsEnabled(boolean isEnabled) {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (component == this.enabledCheckBox) continue;
            component.setEnabled(isEnabled);
        }
    }

    private void initComponents() {
        this.levelLabel = new JLabel();
        this.levelComboBox = new JComboBox();
        this.configLabel = new JLabel();
        this.configComboBox = new JComboBox();
        this.optionsLabel = new JLabel();
        this.optionsTextField = new JTextField();
        this.versionLabel = new JLabel();
        this.versionComboBox = new JComboBox();
        this.enabledCheckBox = new JCheckBox();
        this.codingStandarsFixerLabel = new JLabel();
        this.codingStandardsFixerTextField = new JTextField();
        this.browseButton = new JButton();
        this.searchButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.levelLabel, (String)NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.levelLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.configLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.optionsLabel, (String)NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.optionsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.versionLabel.text"));
        this.versionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodingStandardsFixerCustomizerPanel.this.versionComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.enabledCheckBox, (String)NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.enabledCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.codingStandarsFixerLabel, (String)NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.codingStandarsFixerLabel.text"));
        this.codingStandardsFixerTextField.setText(NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.codingStandardsFixerTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodingStandardsFixerCustomizerPanel.this.browseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodingStandardsFixerCustomizerPanel.this.searchButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.enabledCheckBox).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.codingStandarsFixerLabel).addComponent(this.levelLabel).addComponent(this.configLabel).addComponent(this.optionsLabel).addComponent(this.versionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.levelComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.configComboBox, -2, -1, -2)).addComponent(this.versionComboBox, -2, -1, -2)).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.codingStandardsFixerTextField).addComponent(this.optionsTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.enabledCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codingStandarsFixerLabel).addComponent(this.codingStandardsFixerTextField, -2, -1, -2).addComponent(this.browseButton).addComponent(this.searchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionComboBox, -2, -1, -2).addComponent(this.versionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.levelLabel).addComponent(this.levelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configComboBox, -2, -1, -2).addComponent(this.configLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optionsLabel).addComponent(this.optionsTextField, -2, -1, -2))));
    }

    private void versionComboBoxActionPerformed(ActionEvent evt) {
        switch ((String)this.versionComboBox.getSelectedItem()) {
            case "1": {
                this.setVersion1ComponentsVisible(true);
                break;
            }
            case "2": {
                this.setVersion1ComponentsVisible(false);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File file = AnalysisUiUtils.browseCodingStandardsFixer();
        if (file != null) {
            this.codingStandardsFixerTextField.setText(file.getAbsolutePath());
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        String codingStandardsFixer = AnalysisUiUtils.searchCodingStandardsFixer();
        if (codingStandardsFixer != null) {
            this.codingStandardsFixerTextField.setText(codingStandardsFixer);
        }
    }
}

