/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.analysis.results.Result;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class CodingStandardsFixerReportParser
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(CodingStandardsFixerReportParser.class.getName());
    private final List<Result> results = new ArrayList<Result>();
    private final XMLReader xmlReader;
    private Result currentResult = null;
    private String currentFile = null;
    private final List<String> appliedFixers = new ArrayList<String>();
    private StringBuilder description = null;
    private final FileObject root;

    private CodingStandardsFixerReportParser(FileObject root) throws SAXException {
        this.xmlReader = FileUtils.createXmlReader();
        this.root = root;
    }

    private static CodingStandardsFixerReportParser create(Reader reader, FileObject root) throws SAXException, IOException {
        CodingStandardsFixerReportParser parser = new CodingStandardsFixerReportParser(root);
        parser.xmlReader.setContentHandler(parser);
        parser.xmlReader.parse(new InputSource(reader));
        return parser;
    }

    @CheckForNull
    public static List<Result> parse(File resultFile, FileObject root) {
        List<Result> list;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(resultFile), StandardCharsets.UTF_8));
        try {
            list = CodingStandardsFixerReportParser.create(reader, root).getResults();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SAXException ex) {
                LOGGER.log(Level.INFO, null, ex);
                return null;
            }
        }
        ((Reader)reader).close();
        return list;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("file".equals(qName)) {
            this.processFileStart(attributes);
        } else if ("applied_fixer".equals(qName)) {
            this.appliedFixers.add(attributes.getValue("name"));
        } else if ("diff".equals(qName)) {
            this.processResultStart(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("file".equals(qName)) {
            this.processFileEnd();
        } else if ("diff".equals(qName)) {
            this.processResultEnd();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.description != null) {
            this.description.append(new String(ch, start, length));
        }
    }

    private void processFileStart(Attributes attributes) {
        assert (this.currentResult == null) : this.currentResult.getFilePath();
        assert (this.currentFile == null) : this.currentFile;
        this.currentFile = this.getCurrentFile(attributes.getValue("name"));
    }

    private void processFileEnd() {
        this.currentFile = null;
    }

    private void processResultStart(Attributes attributes) {
        if (this.currentFile == null) {
            return;
        }
        assert (this.currentResult == null) : this.currentResult.getFilePath();
        assert (this.description == null) : this.description.toString();
        this.currentResult = new Result(this.currentFile);
        this.currentResult.setLine(1);
        this.currentResult.setColumn(0);
        this.currentResult.setCategory(StringUtils.implode(this.appliedFixers, (String)","));
        this.description = new StringBuilder(200);
    }

    private void processResultEnd() {
        if (this.currentFile != null) {
            assert (this.currentResult != null);
            assert (this.description != null);
            this.currentResult.setDescription(this.formatDescription(this.description.toString()));
            this.results.add(this.currentResult);
        }
        this.currentResult = null;
        this.appliedFixers.clear();
        this.description = null;
    }

    private String formatDescription(String description) {
        String replaced = description.replaceAll("      (.+\n)", "$1");
        return String.format("<pre>%s</pre>", replaced);
    }

    private String getCurrentFile(String fileName) {
        if (this.root.isFolder()) {
            FileObject current = this.root.getFileObject(fileName);
            if (current == null) {
                return null;
            }
            return FileUtil.toFile((FileObject)current).getAbsolutePath();
        }
        return fileName;
    }

    public List<Result> getResults() {
        return Collections.unmodifiableList(this.results);
    }
}

