/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class SourceForBinaryQueryImpl
implements SourceForBinaryQueryImplementation {
    private final Map<String, SourceForBinaryQuery.Result> cache = new HashMap<String, SourceForBinaryQuery.Result>();
    private EarProject p;

    public SourceForBinaryQueryImpl(EarProject p) {
        this.p = p;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        SourceForBinaryQuery.Result res;
        if (FileUtil.getArchiveFile((URL)binaryRoot) != null) {
            binaryRoot = FileUtil.getArchiveFile((URL)binaryRoot);
        }
        if ((res = this.cache.get(binaryRoot.toExternalForm())) != null) {
            return res;
        }
        FileObject fo = URLMapper.findFileObject((URL)binaryRoot);
        if (fo == null || fo.isFolder()) {
            return null;
        }
        String buildDir = this.p.evaluator().evaluate("${build.dir}/lib");
        if (buildDir == null) {
            return null;
        }
        FileObject libRoot = this.p.getAntProjectHelper().resolveFileObject(buildDir);
        if (libRoot == null) {
            return null;
        }
        if (!fo.getParent().equals(libRoot)) {
            return null;
        }
        String libFile = fo.getNameExt();
        for (Project subProject : ((SubprojectProvider)this.p.getLookup().lookup(SubprojectProvider.class)).getSubprojects()) {
            ClassPath cp;
            SourceGroup[] sgp = ProjectUtils.getSources((Project)subProject).getSourceGroups("java");
            if (sgp.length == 0 || (cp = ClassPath.getClassPath((FileObject)sgp[0].getRootFolder(), (String)"classpath/compile")) == null) continue;
            for (ClassPath.Entry entry : cp.entries()) {
                FileObject cpItem;
                URL u = entry.getURL();
                if (FileUtil.getArchiveFile((URL)u) != null) {
                    u = FileUtil.getArchiveFile((URL)u);
                }
                if (u.toExternalForm().equals(binaryRoot.toExternalForm()) || (cpItem = URLMapper.findFileObject((URL)u)) == null || cpItem.isFolder() || !cpItem.getNameExt().equals(libFile) || (res = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL())) == null) continue;
                this.cache.put(binaryRoot.toExternalForm(), res);
                return res;
            }
        }
        return null;
    }
}

