/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationUtil;

public abstract class AbstractTypedAnalyzer {
    public void analyze(Element element, TypeMirror elementType, AtomicBoolean cancel, CdiAnalysisResult result) {
        CompilationInfo compInfo = result.getInfo();
        List<TypeMirror> list = this.getRestrictedTypes(element, compInfo, cancel);
        if (list == null) {
            return;
        }
        result.requireCdiEnabled(element);
        for (TypeMirror type : list) {
            if (cancel.get()) {
                return;
            }
            boolean isSubtype = this.hasBeanType(element, elementType, type, compInfo);
            if (isSubtype) continue;
            this.addError(element, result);
        }
        if (cancel.get()) {
            return;
        }
        if (AnnotationUtil.hasAnnotation(element, "javax.enterprise.inject.Specializes", compInfo)) {
            result.requireCdiEnabled(element);
            this.checkSpecializes(element, elementType, list, cancel, result);
        }
    }

    protected abstract void checkSpecializes(Element var1, TypeMirror var2, List<TypeMirror> var3, AtomicBoolean var4, CdiAnalysisResult var5);

    protected boolean hasBeanType(Element subject, TypeMirror elementType, TypeMirror requiredBeanType, CompilationInfo compInfo) {
        return compInfo.getTypes().isSubtype(elementType, requiredBeanType);
    }

    protected abstract void addError(Element var1, CdiAnalysisResult var2);

    protected void collectAncestors(TypeElement type, Set<TypeElement> ancestors, CompilationInfo compInfo) {
        TypeMirror superclass = type.getSuperclass();
        this.addAncestor(superclass, ancestors, compInfo);
        List<? extends TypeMirror> interfaces = type.getInterfaces();
        for (TypeMirror typeMirror : interfaces) {
            this.addAncestor(typeMirror, ancestors, compInfo);
        }
    }

    private void addAncestor(TypeMirror parent, Set<TypeElement> ancestors, CompilationInfo compInfo) {
        if (parent == null) {
            return;
        }
        Element parentElement = compInfo.getTypes().asElement(parent);
        if (parentElement instanceof TypeElement) {
            if (ancestors.contains((TypeElement)parentElement)) {
                return;
            }
            ancestors.add((TypeElement)parentElement);
            this.collectAncestors((TypeElement)parentElement, ancestors, compInfo);
        }
    }

    protected List<TypeMirror> getRestrictedTypes(Element element, CompilationInfo compInfo, AtomicBoolean cancel) {
        AnnotationMirror typedMirror = AnnotationUtil.getAnnotationMirror(element, "javax.enterprise.inject.Typed", compInfo);
        if (typedMirror == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = typedMirror.getElementValues();
        AnnotationValue restrictedTypes = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
            ExecutableElement key = entry.getKey();
            AnnotationValue value = entry.getValue();
            if (!"value".contentEquals(key.getSimpleName())) continue;
            restrictedTypes = value;
            break;
        }
        if (restrictedTypes == null) {
            return Collections.emptyList();
        }
        if (cancel.get()) {
            return Collections.emptyList();
        }
        Object value = restrictedTypes.getValue();
        if (value instanceof List) {
            ArrayList<TypeMirror> result = new ArrayList<TypeMirror>(((List)value).size());
            for (Object type : (List)value) {
                AnnotationValue annotationValue = (AnnotationValue)type;
                if (!((type = annotationValue.getValue()) instanceof TypeMirror)) continue;
                result.add((TypeMirror)type);
            }
            return result;
        }
        return Collections.emptyList();
    }

    protected Set<TypeElement> getUnrestrictedBeanTypes(TypeElement element, CompilationInfo compInfo) {
        HashSet<TypeElement> set = new HashSet<TypeElement>();
        set.add(element);
        this.collectAncestors(element, set, compInfo);
        return set;
    }

    protected Set<TypeElement> getElements(Collection<TypeMirror> types, CompilationInfo info) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        for (TypeMirror typeMirror : types) {
            Element element = info.getTypes().asElement(typeMirror);
            if (!(element instanceof TypeElement)) continue;
            result.add((TypeElement)element);
        }
        return result;
    }
}

