/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.web.javascript.debugger.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.Bundle;

public class EventsBreakpoint
extends AbstractBreakpoint {
    private static final String[][] EVENTS = new String[][]{{Bundle.LBL_Event_Category_Animation(), "requestAnimationFrame", "cancelAnimationFrame", "animationFrameFired"}, {Bundle.LBL_Event_Category_Clipboard(), "copy", "cut", "paste", "beforecopy", "beforecut", "beforepaste"}, {Bundle.LBL_Event_Category_Control(), "resize", "scroll", "zoom", "focus", "blur", "select", "change", "submit", "reset"}, {Bundle.LBL_Event_Category_DOM_Mutation(), "DOMActivate", "DOMFocusIn", "DOMFocusOut", "DOMAttrModified", "DOMCharacterDataModified", "DOMNodeInserted", "DOMNodeInsertedIntoDocument", "DOMNodeRemoved", "DOMNodeRemovedFromDocument", "DOMSubtreeModified", "DOMContentLoaded"}, {Bundle.LBL_Event_Category_Device(), "deviceorientation", "devicemotion"}, {Bundle.LBL_Event_Category_Keyboard(), "keydown", "keyup", "keypress", "textInput"}, {Bundle.LBL_Event_Category_Load(), "load", "unload", "abort", "error"}, {Bundle.LBL_Event_Category_Mouse(), "click", "dblclick", "mousedown", "mouseup", "mouseover", "mousemove", "mouseout", "mousewheel"}, {Bundle.LBL_Event_Category_Timer(), "setTimer", "clearTimer", "timerFired"}, {Bundle.LBL_Event_Category_Touch(), "touchstart", "touchmove", "touchend", "touchcancel"}};
    private static final boolean[] INSTRUMENTATION = new boolean[]{true, false, false, false, false, false, false, false, true, false};
    public static final String PROP_EVENTS = "events";
    private static final Set<String> categories;
    private static final Map<String, Set<String>> eventsByCategories;
    private static final Map<String, String> categoryOf;
    private static final Set<String> instrumentationEvents;
    private final Set<String> events = new HashSet<String>();

    public static Set<String> getAllEventCategories() {
        return categories;
    }

    public static Set<String> getAllEvents(String category) {
        return eventsByCategories.get(category);
    }

    public static String getCategoryOf(String event) {
        return categoryOf.get(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getEvents() {
        Set<String> set = this.events;
        synchronized (set) {
            return Collections.unmodifiableSet(new HashSet<String>(this.events));
        }
    }

    public boolean isInstrumentationEvent(String event) {
        return instrumentationEvents.contains(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(String event) {
        boolean added;
        Set<String> set = this.events;
        synchronized (set) {
            added = this.events.add(event);
        }
        if (added) {
            this.firePropertyChange(PROP_EVENTS, null, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEvent(String event) {
        boolean removed;
        Set<String> set = this.events;
        synchronized (set) {
            removed = this.events.remove(event);
        }
        if (removed) {
            this.firePropertyChange(PROP_EVENTS, event, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEvent(String event) {
        Set<String> set = this.events;
        synchronized (set) {
            return this.events.contains(event);
        }
    }

    static {
        int n = EVENTS.length;
        assert (INSTRUMENTATION.length == n);
        HashMap ebcm = new HashMap(n);
        HashMap<String, String> catOf = new HashMap<String, String>();
        HashSet<String> instrEv = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            LinkedHashSet<String> evts = new LinkedHashSet<String>(EVENTS[i].length - 1);
            boolean isInstrumentation = INSTRUMENTATION[i];
            for (int j = 1; j < EVENTS[i].length; ++j) {
                String event = EVENTS[i][j];
                evts.add(event);
                catOf.put(event, EVENTS[i][0]);
                if (!isInstrumentation) continue;
                instrEv.add(event);
            }
            ebcm.put(EVENTS[i][0], evts);
        }
        eventsByCategories = Collections.unmodifiableMap(ebcm);
        TreeSet categoriesSet = new TreeSet(ebcm.keySet());
        categories = Collections.unmodifiableSortedSet(categoriesSet);
        categoryOf = Collections.unmodifiableMap(catOf);
        instrumentationEvents = Collections.unmodifiableSet(instrEv);
    }
}

