/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.rest.wizard;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.web.client.rest.wizard.JSClientGenerator;
import org.netbeans.modules.web.client.rest.wizard.ModelAttribute;
import org.netbeans.modules.web.client.rest.wizard.ModelGenerator;
import org.netbeans.modules.web.client.rest.wizard.RestPanel;

class RouterGenerator {
    private ModelGenerator myModelGenerator;
    private StringBuilder myRouters;
    private String myRouterName;
    private String myDetailsTemplateName;
    private String mySideBarId;
    private String myListItemTemplate;

    RouterGenerator(StringBuilder routers, String name, ModelGenerator generator) {
        this.myRouters = routers;
        this.myRouterName = name;
        this.myModelGenerator = generator;
    }

    void generateRouter(TypeElement entity, String path, String collectionPath, Map<JSClientGenerator.HttpRequests, String> httpPaths, CompilationController controller) {
        StringBuilder builder;
        this.myRouters.append("var ");
        this.myRouters.append(this.myRouterName);
        this.myRouters.append(" = Backbone.Router.extend({\n");
        boolean hasCollection = collectionPath != null;
        String modelVar = this.getModelGenerator().getModelName().toLowerCase(Locale.ENGLISH);
        this.myRouters.append("routes:{\n");
        if (hasCollection) {
            this.myRouters.append("'':'list'");
        } else {
            this.myRouters.append("'':'details'");
        }
        if (httpPaths.get((Object)JSClientGenerator.HttpRequests.POST) != null) {
            this.myRouters.append(",\n'new':'create'\n");
        }
        if (hasCollection) {
            this.myRouters.append(",\n':id':'details'\n");
        }
        this.myRouters.append("},\n");
        this.myRouters.append("initialize:function(){\n");
        this.myRouters.append("var self = this;\n");
        this.myRouters.append("$('#");
        this.myRouters.append(this.getHeaderId());
        this.myRouters.append("').html(new views.CreateView({\n");
        this.myRouters.append(" // tpl-create is template identifier for 'create' block\n");
        this.myRouters.append("templateName :'#");
        this.myRouters.append(this.getCreateTemplate());
        this.myRouters.append("',\n");
        this.myRouters.append("navigate: function(){\n");
        this.myRouters.append("self.navigate('new', true);\n}\n");
        this.myRouters.append("}).render().el);\n},\n");
        if (hasCollection) {
            this.mySideBarId = this.useUi() ? "datatable" : "sidebar";
            this.myRouters.append("list:function () {\n");
            this.myRouters.append("this.collection = new models.");
            this.myRouters.append(this.getModelGenerator().getCollectionModelName());
            this.myRouters.append("();\nvar self = this;\n");
            this.myRouters.append("this.collection.fetch({\n");
            this.myRouters.append("success:function () {\n");
            this.myRouters.append("self.listView = new views.ListView({\n");
            this.myRouters.append("model:self.collection,\n");
            builder = new StringBuilder("tpl-");
            builder.append(modelVar);
            builder.append("-list-item");
            this.myListItemTemplate = builder.toString();
            this.myRouters.append(" // ");
            this.myRouters.append(this.myListItemTemplate);
            this.myRouters.append("is template identifier for item\n");
            this.myRouters.append("templateName : '#");
            this.myRouters.append(this.myListItemTemplate);
            this.myRouters.append("'\n});\n");
            this.myRouters.append("$('#");
            this.myRouters.append(this.getSideBarId());
            this.myRouters.append("').html(self.listView.render().el)");
            if (this.useUi()) {
                this.myRouters.append(".append(_.template($('#");
                this.myRouters.append(this.getTableHeadId());
                this.myRouters.append("').html())())");
            }
            this.myRouters.append(";\nif (self.requestedId) {\n");
            this.myRouters.append("self.details(self.requestedId);\n}\n");
            if (this.useUi()) {
                this.myRouters.append("var pagerOptions = {\n");
                this.myRouters.append(" // target the pager markup \n");
                this.myRouters.append("container: $('.pager'),\n");
                this.myRouters.append(" // output string - default is ");
                this.myRouters.append("'{page}/{totalPages}'; possible");
                this.myRouters.append("variables: {page}, {totalPages},");
                this.myRouters.append("{startRow}, {endRow} and {totalRows}\n");
                this.myRouters.append("output: '{startRow} to");
                this.myRouters.append(" {endRow} ({totalRows})',\n");
                this.myRouters.append(" // starting page of the pager (zero based index)\n");
                this.myRouters.append("page: 0,\n");
                this.myRouters.append(" // Number of visible rows - default is 10\n");
                this.myRouters.append("size: 10\n};\n$('#");
                this.myRouters.append(this.getSideBarId());
                this.myRouters.append("').tablesorter({widthFixed: true, \n");
                this.myRouters.append("widgets: ['zebra']}).\n");
                this.myRouters.append("tablesorterPager(pagerOptions);\n");
            }
            this.myRouters.append("}\n});\n},\n");
        }
        builder = new StringBuilder("tpl-");
        builder.append(modelVar);
        builder.append("-details");
        this.myDetailsTemplateName = builder.toString();
        this.myRouters.append("details:function (");
        if (hasCollection) {
            this.myRouters.append("id");
        }
        this.myRouters.append("){\n");
        if (hasCollection) {
            this.myRouters.append("if (this.collection) {\n");
            this.myRouters.append("this.");
            this.myRouters.append(modelVar);
            this.myRouters.append("= this.collection.get(id);\n");
            this.myRouters.append("if (this.view) {\n");
            this.myRouters.append("this.view.close();\n}\n");
            this.myRouters.append("var self = this;\n");
            this.myRouters.append("this.view = new views.ModelView({\n");
            this.myRouters.append("model:this.");
            this.myRouters.append(modelVar);
            this.myRouters.append(",\n // ");
            this.myRouters.append(this.myDetailsTemplateName);
            this.myRouters.append(" is template identifier for chosen model element\n");
            this.myRouters.append("templateName: '#");
            this.myRouters.append(this.myDetailsTemplateName);
            this.myRouters.append("',\ngetHashObject: function(){\n");
            this.myRouters.append("return self.getData();\n}\n});\n");
            this.myRouters.append("$('#");
            this.myRouters.append(this.getContentId());
            this.myRouters.append("').html(this.view.render().el);");
            this.myRouters.append("} else {\n");
            this.myRouters.append("this.requestedId = id;\n");
            this.myRouters.append("this.list();\n}\n},\n");
        } else {
            this.myRouters.append("if (this.view) {\n");
            this.myRouters.append("this.view.close();\n}\n");
            this.myRouters.append("var self = this;\n");
            this.myRouters.append("this.");
            this.myRouters.append(modelVar);
            this.myRouters.append(" = models.");
            this.myRouters.append(this.getModelGenerator().getModelName());
            this.myRouters.append("();\nthis.");
            this.myRouters.append(modelVar);
            this.myRouters.append(".fetch({\n");
            this.myRouters.append("success:function(){\n");
            this.myRouters.append("self.view = new views.ModelView({\n");
            this.myRouters.append("model: self.newclass,\n // ");
            this.myRouters.append(this.myDetailsTemplateName);
            this.myRouters.append(" is template identifier for chosen model element\n");
            this.myRouters.append("templateName : '#");
            this.myRouters.append(this.myDetailsTemplateName);
            this.myRouters.append("'\n});\n");
            this.myRouters.append("$('#");
            this.myRouters.append(this.getContentId());
            this.myRouters.append("').html(self.view.render().el);}\n});\n},\n");
        }
        if (httpPaths.get((Object)JSClientGenerator.HttpRequests.POST) != null) {
            this.myRouters.append("create:function () {\n");
            this.myRouters.append("if (this.view) {\n");
            this.myRouters.append("this.view.close();\n}\n");
            this.myRouters.append("var self = this;\n");
            this.myRouters.append("var dataModel = new models.");
            this.myRouters.append(this.getModelGenerator().getModelName());
            this.myRouters.append("();\n");
            this.myRouters.append(" // see isNew() method implementation in the model\n");
            this.myRouters.append("dataModel.notSynced = true;\n");
            this.myRouters.append("this.view = new views.ModelView({\n");
            this.myRouters.append("model: dataModel,\n");
            if (hasCollection) {
                this.myRouters.append("collection: this.collection,\n");
            }
            this.myRouters.append(" // ");
            this.myRouters.append(this.myDetailsTemplateName);
            this.myRouters.append(" is a template identifier for chosen model element\n");
            this.myRouters.append("templateName: '#");
            this.myRouters.append(this.myDetailsTemplateName);
            this.myRouters.append("',\n");
            this.myRouters.append("navigate: function( id ){\n");
            this.myRouters.append("self.navigate(id, false);\n},\n\n");
            this.myRouters.append("getHashObject: function(){\n");
            this.myRouters.append("return self.getData();\n}\n");
            this.myRouters.append("});\n");
            this.myRouters.append("$('#");
            this.myRouters.append(this.getContentId());
            this.myRouters.append("').html(this.view.render().el);\n},\n");
        }
        this.myRouters.append("getData: function(){\n");
        this.myRouters.append("return {\n");
        if (this.useUi()) {
            ModelAttribute id = this.getModelGenerator().getIdAttribute();
            if (id != null) {
                this.myRouters.append(id.getName());
                this.myRouters.append(":$('#");
                this.myRouters.append(id.getName());
                this.myRouters.append("').val(),\n");
            }
            Set<ModelAttribute> attributes = this.getModelGenerator().getAttributes();
            int size = attributes.size();
            int i = 0;
            for (ModelAttribute attribute : attributes) {
                this.myRouters.append(attribute.getName());
                this.myRouters.append(":$('#");
                this.myRouters.append(attribute.getName());
                this.myRouters.append("').val()");
                if (++i < size) {
                    this.myRouters.append(',');
                }
                this.myRouters.append("\n");
            }
        } else {
            String mainModelAttribute = this.getModelGenerator().getDisplayNameAlias();
            this.myRouters.append("/*\n * get values from the HTML controls and");
            this.myRouters.append(" put them here as a hash of attributes\n");
            if (mainModelAttribute != null) {
                this.myRouters.append(" * f.e.\n * ");
                this.myRouters.append(mainModelAttribute);
                this.myRouters.append(":$('#");
                this.myRouters.append(mainModelAttribute);
                this.myRouters.append("').val(),\n * ....\n");
            }
            this.myRouters.append(" */\n");
        }
        this.myRouters.append("};\n}\n");
        this.myRouters.append("});\n");
        this.myRouters.append("new ");
        this.myRouters.append(this.myRouterName);
        this.myRouters.append("();\n");
    }

    ModelGenerator getModelGenerator() {
        return this.myModelGenerator;
    }

    String getDetailsTemplate() {
        return this.myDetailsTemplateName;
    }

    String getListItemTemplate() {
        return this.myListItemTemplate;
    }

    String getCreateTemplate() {
        return "tpl-create";
    }

    String getTableHeadId() {
        return "thead";
    }

    String getHeaderId() {
        if (this.useUi()) {
            return "create";
        }
        return "header";
    }

    boolean useUi() {
        return this.getModelGenerator().hasCollection() && this.getModelGenerator().getUi() == RestPanel.JsUi.TABLESORTER;
    }

    String getContentId() {
        if (this.useUi()) {
            return "details";
        }
        return "content";
    }

    String getSideBarId() {
        return this.mySideBarId;
    }
}

