/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.grunt.file;

import java.awt.EventQueue;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.grunt.exec.GruntExecutable;
import org.netbeans.modules.javascript.grunt.file.Gruntfile;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

public final class GruntTasks
implements ChangeListener {
    public static final String DEFAULT_TASK = "default";
    private final Project project;
    private final Gruntfile gruntfile;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    final FileChangeListener nodeModulesListener = new NodeModulesListener();
    private volatile List<String> tasks;

    private GruntTasks(Project project, Gruntfile gruntfile) {
        assert (project != null);
        assert (gruntfile != null);
        this.project = project;
        this.gruntfile = gruntfile;
    }

    public static GruntTasks create(Project project, Gruntfile gruntfile) {
        assert (project != null);
        assert (gruntfile != null) : project.getProjectDirectory();
        GruntTasks gruntTasks = new GruntTasks(project, gruntfile);
        gruntfile.addChangeListener(gruntTasks);
        FileUtil.addFileChangeListener((FileChangeListener)gruntTasks.nodeModulesListener, (File)new File(gruntfile.getFile().getParent(), "node_modules"));
        return gruntTasks;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @CheckForNull
    public List<String> getTasks() {
        List<String> tasksRef = this.tasks;
        return tasksRef == null ? null : Collections.unmodifiableList(tasksRef);
    }

    public List<String> loadTasks(@NullAllowed Long timeout, @NullAllowed TimeUnit unit) throws ExecutionException, TimeoutException {
        List<String> tasksRef = this.tasks;
        if (tasksRef != null) {
            return Collections.unmodifiableList(tasksRef);
        }
        assert (!EventQueue.isDispatchThread());
        Future<List<String>> tasksJob = this.getTasksJob();
        if (tasksJob == null) {
            return null;
        }
        try {
            List<String> allTasks;
            if (timeout != null) {
                assert (unit != null);
                allTasks = tasksJob.get(timeout, unit);
            } else {
                allTasks = tasksJob.get();
            }
            this.tasks = new CopyOnWriteArrayList<String>(allTasks);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return this.getTasks();
    }

    @CheckForNull
    private Future<List<String>> getTasksJob() {
        GruntExecutable grunt = GruntExecutable.getDefault(this.project, this.gruntfile.getFile().getParentFile(), false);
        if (grunt == null) {
            return null;
        }
        return grunt.listTasks();
    }

    public void reset() {
        this.tasks = null;
        this.changeSupport.fireChange();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.reset();
    }

    private final class NodeModulesListener
    extends FileChangeAdapter {
        private NodeModulesListener() {
        }

        public void fileRenamed(FileRenameEvent fe) {
            GruntTasks.this.reset();
        }

        public void fileDeleted(FileEvent fe) {
            GruntTasks.this.reset();
        }

        public void fileFolderCreated(FileEvent fe) {
            GruntTasks.this.reset();
        }
    }
}

