/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.wizards.DeployData;
import org.netbeans.modules.web.wizards.Evaluator;
import org.netbeans.modules.web.wizards.FileType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;

public class TargetEvaluator
extends Evaluator {
    private List<String> pathItems = null;
    private DeployData deployData = null;
    private String fileName;
    private String className;

    TargetEvaluator(FileType fileType, DeployData deployData) {
        super(fileType);
        this.deployData = deployData;
    }

    @Override
    String getErrorMessage() {
        return "";
    }

    DeployData getDeployData() {
        return this.deployData;
    }

    String getClassName() {
        return this.className;
    }

    void setClassName(String fileName, String targetFolder) {
        this.className = targetFolder.length() > 0 ? targetFolder + "." + fileName : fileName;
        this.fileName = fileName;
    }

    String getFileName() {
        return this.fileName;
    }

    @Override
    Iterator<String> getPathItems() {
        return this.pathItems.iterator();
    }

    @Override
    String getTargetPath() {
        return super.getTargetPath(this.pathItems.iterator());
    }

    @Override
    void setInitialFolder(DataFolder selectedFolder, Project p) {
        if (selectedFolder == null) {
            return;
        }
        FileObject targetFolder = selectedFolder.getPrimaryFile();
        Sources sources = ProjectUtils.getSources((Project)p);
        SourceGroup[] groups = sources.getSourceGroups("java");
        String packageName = null;
        for (int i = 0; i < groups.length && packageName == null; ++i) {
            packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)targetFolder);
            this.deployData.setWebApp(DeployData.getWebAppFor(groups[i].getRootFolder()));
        }
        if (packageName == null) {
            packageName = "";
        }
        this.setInitialPath(packageName);
    }

    @Override
    boolean isValid() {
        return true;
    }

    private void setInitialPath(String dirPath) {
        this.pathItems = new ArrayList<String>();
        String[] path = dirPath.split("/");
        if (path.length > 0) {
            for (int i = 0; i < path.length; ++i) {
                if (path[i].equals("")) continue;
                this.pathItems.add(path[i]);
            }
        }
    }
}

