/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.keyinfo;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.keyinfo.KeyInfoStrategy;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KeyNameStrategy
extends KeyInfoStrategy {
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    String keyName;

    public KeyNameStrategy() {
        this.keyName = null;
    }

    public KeyNameStrategy(String alias, boolean forSigning) {
        this.keyName = alias;
    }

    @Override
    public void insertKey(SecurityTokenReference tokenRef, SecurableSoapMessage secureMsg) throws XWSSecurityException {
        log.log(Level.SEVERE, LogStringsMessages.WSS_0703_UNSUPPORTED_OPERATION());
        throw new UnsupportedOperationException("A ds:KeyName can't be put under a wsse:SecurityTokenReference");
    }

    @Override
    public void insertKey(KeyInfoHeaderBlock keyInfo, SecurableSoapMessage secureMsg, String x509TokenId) throws XWSSecurityException {
        keyInfo.addKeyName(this.keyName);
    }

    @Override
    public void setCertificate(X509Certificate cert) {
        log.log(Level.SEVERE, LogStringsMessages.WSS_0705_UNSUPPORTED_OPERATION());
        throw new UnsupportedOperationException("Setting a certificate is not a supported operation for ds:KeyName strategy");
    }

    public String getKeyName() {
        return this.keyName;
    }

    @Override
    public String getAlias() {
        return this.keyName;
    }

    public void setKeyName(String name) {
        this.keyName = name;
    }
}

