/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.simpletype;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.simpletype.EncoderUtils;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoderBase;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;

public class XSDBooleanEncoder
extends SimpleTypeEncoderBase {
    private static final SimpleTypeEncoder encoder = new XSDBooleanEncoder();

    private XSDBooleanEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    @Override
    public String objectToString(Object obj, XMLWriter writer) throws Exception {
        if (obj == null) {
            return null;
        }
        return ((Boolean)obj).toString();
    }

    @Override
    public Object stringToObject(String str, XMLReader reader) throws Exception {
        if (str == null) {
            return null;
        }
        String tmp = EncoderUtils.collapseWhitespace(str);
        if (tmp.equals("true")) {
            return Boolean.TRUE;
        }
        if (tmp.equals("false")) {
            return Boolean.FALSE;
        }
        if (tmp.equals("1")) {
            return Boolean.TRUE;
        }
        if (tmp.equals("0")) {
            return Boolean.FALSE;
        }
        throw new DeserializationException("xsd.invalid.boolean", tmp);
    }

    @Override
    public void writeValue(Object obj, XMLWriter writer) throws Exception {
        writer.writeCharsUnquoted(this.objectToString(obj, writer));
    }
}

