/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.micronaut.Bundle;
import org.netbeans.modules.micronaut.MicronautConfigProperties;
import org.netbeans.modules.micronaut.MicronautConfigUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;

public class MicronautConfigValidator
implements HintsProvider {
    public void computeHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints) {
    }

    public void computeSuggestions(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int caretOffset) {
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int start, int end) {
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        FileObject fo = EditorDocumentUtils.getFileObject((Document)context.doc);
        if (MicronautConfigUtilities.isMicronautConfigFile(fo)) {
            Map<String, ConfigurationMetadataProperty> properties;
            List structures;
            StructureScanner scanner;
            Language language;
            Project project;
            ParserResult parserResult = context.parserResult;
            List diagnostics = parserResult.getDiagnostics();
            if (diagnostics != null && !diagnostics.isEmpty()) {
                unhandled.addAll(diagnostics);
            }
            if ((project = FileOwnerQuery.getOwner((FileObject)fo)) != null && MicronautConfigProperties.hasConfigMetadata(project) && (language = LanguageRegistry.getInstance().getLanguageByMimeType(parserResult.getSnapshot().getMimeType())) != null && (scanner = language.getStructure()) != null && !(structures = scanner.scan(parserResult)).isEmpty() && !(properties = MicronautConfigProperties.getProperties(project)).isEmpty()) {
                MicronautConfigValidator.validate(parserResult, structures, "", properties, unhandled);
            }
        }
    }

    public void cancel() {
    }

    public List<Rule> getBuiltinRules() {
        return null;
    }

    public RuleContext createRuleContext() {
        return new RuleContext();
    }

    private static void validate(ParserResult parserResult, List<? extends StructureItem> structure, String name, Map<String, ConfigurationMetadataProperty> properties, List<Error> errors) {
        FileObject fileObject = parserResult.getSnapshot().getSource().getFileObject();
        CharSequence text = parserResult.getSnapshot().getText();
        block18: for (StructureItem structureItem : structure) {
            String fullName = name.isEmpty() ? structureItem.getName() : name + '.' + structureItem.getName();
            List nestedItems = structureItem.getNestedItems();
            if (nestedItems.isEmpty()) {
                String type;
                ConfigurationMetadataProperty property = properties.get(fullName);
                if (property == null || (type = property.getType()) == null || "java.lang.String".equals(type)) continue;
                try {
                    String value;
                    String itemText = text.subSequence((int)structureItem.getPosition(), (int)structureItem.getEndPosition()).toString();
                    int idx = itemText.lastIndexOf(58);
                    if (idx < 0 || (value = itemText.substring(idx + 1).trim()).isEmpty()) continue;
                    int start = (int)structureItem.getPosition() + itemText.indexOf(value, idx + 1);
                    int end = start + value.length();
                    switch (type) {
                        case "boolean": {
                            if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) continue block18;
                            errors.add(DefaultError.createDefaultError(null, (String)Bundle.MSG_InvalidValue(value, type), null, (FileObject)fileObject, (int)start, (int)end, (boolean)false, (Severity)Severity.ERROR));
                            break;
                        }
                        case "java.lang.Integer": {
                            try {
                                Integer.parseInt(value);
                            }
                            catch (NumberFormatException e) {
                                errors.add(DefaultError.createDefaultError(null, (String)Bundle.MSG_InvalidValue(value, type), null, (FileObject)fileObject, (int)start, (int)end, (boolean)false, (Severity)Severity.ERROR));
                            }
                            break;
                        }
                        case "java.lang.Long": {
                            try {
                                Long.parseLong(value);
                            }
                            catch (NumberFormatException e) {
                                errors.add(DefaultError.createDefaultError(null, (String)Bundle.MSG_InvalidValue(value, type), null, (FileObject)fileObject, (int)start, (int)end, (boolean)false, (Severity)Severity.ERROR));
                            }
                            break;
                        }
                        default: {
                            JavaSource js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)fileObject), (FileObject[])new FileObject[0]);
                            if (js == null) continue block18;
                            try {
                                js.runUserActionTask(cc -> {
                                    cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                    TypeElement typeElement = cc.getElements().getTypeElement(type);
                                    if (typeElement != null && typeElement.getKind() == ElementKind.ENUM && !typeElement.getEnclosedElements().stream().anyMatch(e -> e.getKind() == ElementKind.ENUM_CONSTANT && value.contentEquals(e.getSimpleName()))) {
                                        errors.add(DefaultError.createDefaultError(null, (String)Bundle.MSG_InvalidValue(value, type), null, (FileObject)fileObject, (int)start, (int)end, (boolean)false, (Severity)Severity.ERROR));
                                    }
                                }, true);
                                break;
                            }
                            catch (IOException ioe) {
                                Exceptions.printStackTrace((Throwable)ioe);
                            }
                        }
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                continue;
            }
            MicronautConfigValidator.validate(parserResult, nestedItems, fullName, properties, errors);
        }
    }
}

