/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.api.indexing;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.impl.indexing.IndexingUtils;
import org.netbeans.modules.parsing.impl.indexing.LogContext;
import org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.openide.filesystems.FileObject;

public final class IndexingManager {
    private static final Logger LOG = Logger.getLogger(IndexingManager.class.getName());
    private static IndexingManager instance;

    public static synchronized IndexingManager getDefault() {
        if (instance == null) {
            instance = new IndexingManager();
        }
        return instance;
    }

    public boolean isIndexing() {
        return IndexingUtils.isScanInProgress();
    }

    public void refreshIndex(URL root, Collection<? extends URL> files) {
        this.refreshIndex(root, files, true, false);
    }

    public void refreshIndex(URL root, Collection<? extends URL> files, boolean fullRescan) {
        this.refreshIndex(root, files, fullRescan, false);
    }

    public void refreshIndex(@NonNull URL root, @NullAllowed Collection<? extends URL> files, boolean fullRescan, boolean checkEditor) {
        this.addIndexingJob(root, files, false, checkEditor, false, fullRescan, true);
    }

    public void refreshIndexAndWait(URL root, Collection<? extends URL> files) {
        this.refreshIndexAndWait(root, files, true, false);
    }

    public void refreshIndexAndWait(URL root, Collection<? extends URL> files, boolean fullRescan) {
        this.refreshIndexAndWait(root, files, fullRescan, false);
    }

    public void refreshIndexAndWait(URL root, Collection<? extends URL> files, boolean fullRescan, boolean checkEditor) throws IllegalStateException {
        if (ParserManager.isParsing()) {
            throw new IllegalStateException("The caller holds TaskProcessor.parserLock");
        }
        if (RepositoryUpdater.getDefault().isIndexer()) {
            throw new IllegalStateException("The IndexingManager.refreshIndexAndWait called from an indexer");
        }
        this.addIndexingJob(root, files, false, checkEditor, true, fullRescan, true);
    }

    public void refreshAllIndices(String indexerName) {
        if (indexerName != null) {
            LOG.log(Level.FINEST, "Request to refresh indexer: {0} in all roots.", indexerName);
            RepositoryUpdater.getDefault().addIndexingJob(indexerName, LogContext.create(LogContext.EventType.MANAGER, null));
        } else {
            this.refreshAll(true, false, false, new Object[0]);
        }
    }

    public void refreshAllIndices(FileObject ... filesOrFolders) {
        this.refreshAllIndices(true, false, filesOrFolders);
    }

    public void refreshAllIndices(boolean fullRescan, boolean wait, FileObject ... filesOrFolders) {
        this.refreshAll(fullRescan, wait, false, filesOrFolders);
    }

    public void refreshAllIndices(boolean fullRescan, boolean wait, File ... filesOrFolders) {
        this.refreshAll(fullRescan, wait, false, filesOrFolders);
    }

    public <T> T runProtected(Callable<T> operation) throws Exception {
        IndexingController.getDefault().enterProtectedMode();
        try {
            T t = operation.call();
            return t;
        }
        finally {
            IndexingController.getDefault().exitProtectedMode(null);
        }
    }

    private IndexingManager() {
        RepositoryUpdater.getDefault().start(false);
    }

    private void refreshAll(boolean fullRescan, boolean wait, boolean logStatistics, Object ... filesOrFileObjects) {
        LOG.log(Level.FINEST, "Request to refresh all indexes");
        RepositoryUpdater.getDefault().refreshAll(fullRescan, wait, logStatistics, LogContext.create(LogContext.EventType.MANAGER, null), filesOrFileObjects);
    }

    private void addIndexingJob(@NonNull URL rootUrl, @NullAllowed Collection<? extends URL> fileUrls, boolean followUpJob, boolean checkEditor, boolean wait, boolean forceRefresh, boolean steady) {
        LOG.log(Level.FINEST, "Request to add indexing job for root: {0}", rootUrl);
        RepositoryUpdater.getDefault().addIndexingJob(rootUrl, fileUrls, followUpJob, checkEditor, wait, forceRefresh, steady, LogContext.create(LogContext.EventType.MANAGER, null).withRoot(rootUrl));
    }
}

