/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;

public class DiffFileEncodingQueryImplementation
extends FileEncodingQueryImplementation {
    public Charset getEncoding(FileObject file) {
        if (!"text/x-diff".equals(file.getMIMEType())) {
            return null;
        }
        return this.generatedByIDE(file) ? StandardCharsets.UTF_8 : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generatedByIDE(FileObject file) {
        if (file.getSize() <= (long)"# This patch file was generated by NetBeans IDE".length()) {
            return false;
        }
        byte[] buffer = new byte["# This patch file was generated by NetBeans IDE".length()];
        InputStream is = null;
        try {
            is = file.getInputStream();
            int n = is.read(buffer);
            boolean bl = n > 0 && "# This patch file was generated by NetBeans IDE".startsWith(new String(buffer, 0, n, StandardCharsets.US_ASCII));
            return bl;
        }
        catch (IOException e) {
            Logger.getLogger(DiffFileEncodingQueryImplementation.class.getName()).log(Level.INFO, "FEQ failed", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

