/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties.syntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EventListener;
import java.util.HashSet;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.editor.Coloring;
import org.netbeans.modules.properties.TableViewSettings;
import org.netbeans.modules.properties.syntax.PropertiesTokenContext;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public class EditorSettingsCopy
extends TableViewSettings {
    private static EditorSettingsCopy editorSettingsCopy;
    private Font font;
    private Color keyColor;
    private Color keyBackground;
    private Color valueColor;
    private Color valueBackground;
    private Color highlightColor;
    private Color highlightBackground;
    private Color shadowColor;
    private KeyStroke[] keyStrokesFindNext;
    private KeyStroke[] keyStrokesFindPrevious;
    private KeyStroke[] keyStrokesToggleHighlight;
    private final PropertyChangeSupport support = new PropertyChangeSupport((Object)this);
    private boolean prepared = false;
    private Lookup.Result<FontColorSettings> fontsColors = null;
    private final LookupListener fontsColorsTracker = new LookupListener(){

        public void resultChanged(LookupEvent ev) {
            EditorSettingsCopy.this.updateColors();
        }
    };
    private Lookup.Result<KeyBindingSettings> keybindings = null;
    private final LookupListener keybindingsTracker = new LookupListener(){

        public void resultChanged(LookupEvent ev) {
            EditorSettingsCopy.this.updateKeyStrokes();
        }
    };

    private EditorSettingsCopy() {
    }

    public Color getKeyColor() {
        this.prepareSettings();
        if (this.keyColor == null) {
            this.keyColor = TableViewSettings.KEY_DEFAULT_COLOR;
        }
        return this.keyColor;
    }

    public Color getKeyBackground() {
        this.prepareSettings();
        if (this.keyBackground == null) {
            this.keyBackground = TableViewSettings.KEY_DEFAULT_BACKGROUND;
        }
        return this.keyBackground;
    }

    public Color getValueColor() {
        this.prepareSettings();
        if (this.valueColor == null) {
            this.valueColor = TableViewSettings.VALUE_DEFAULT_COLOR;
        }
        return this.valueColor;
    }

    public Color getValueBackground() {
        this.prepareSettings();
        if (this.valueBackground == null) {
            this.valueBackground = TableViewSettings.VALUE_DEFAULT_BACKGROUND;
        }
        return this.valueBackground;
    }

    public Color getHighlightColor() {
        this.prepareSettings();
        if (this.highlightColor == null) {
            this.highlightColor = TableViewSettings.HIGHLIGHT_DEFAULT_COLOR;
        }
        return this.highlightColor;
    }

    public Color getHighlightBackground() {
        this.prepareSettings();
        if (this.highlightBackground == null) {
            this.highlightBackground = TableViewSettings.HIGHLIGHT_DEFAULT_BACKGROUND;
        }
        return this.highlightBackground;
    }

    public Color getShadowColor() {
        this.prepareSettings();
        if (this.shadowColor == null) {
            this.shadowColor = TableViewSettings.SHADOW_DEFAULT_COLOR;
        }
        return this.shadowColor;
    }

    public Font getFont() {
        this.prepareSettings();
        return this.font;
    }

    public KeyStroke[] getKeyStrokesFindNext() {
        this.prepareSettings();
        if (this.keyStrokesFindNext == null || this.keyStrokesFindNext.length == 0) {
            this.keyStrokesFindNext = TableViewSettings.FIND_NEXT_DEFAULT_KEYSTROKES;
        }
        return this.keyStrokesFindNext;
    }

    public KeyStroke[] getKeyStrokesFindPrevious() {
        this.prepareSettings();
        if (this.keyStrokesFindPrevious == null || this.keyStrokesFindPrevious.length == 0) {
            this.keyStrokesFindPrevious = TableViewSettings.FIND_PREVIOUS_DEFAULT_KEYSTROKES;
        }
        return this.keyStrokesFindPrevious;
    }

    public KeyStroke[] getKeyStrokesToggleHighlight() {
        this.prepareSettings();
        if (this.keyStrokesToggleHighlight == null || this.keyStrokesToggleHighlight.length == 0) {
            this.keyStrokesToggleHighlight = TableViewSettings.TOGGLE_HIGHLIGHT_DEFAULT_KEYSTROKES;
        }
        return this.keyStrokesToggleHighlight;
    }

    public void settingsUpdated() {
        if (this.prepared) {
            this.support.firePropertyChange(new PropertyChangeEvent((Object)this, null, null, null));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public static synchronized EditorSettingsCopy getLayerInstance() {
        if (editorSettingsCopy == null) {
            editorSettingsCopy = new EditorSettingsCopy();
        }
        return editorSettingsCopy;
    }

    private void prepareSettings() {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        this.fontsColors = MimeLookup.getLookup((String)"text/x-properties").lookupResult(FontColorSettings.class);
        this.fontsColors.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.fontsColorsTracker, this.fontsColors));
        this.keybindings = MimeLookup.getLookup((String)"text/x-properties").lookupResult(KeyBindingSettings.class);
        this.keybindings.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.keybindingsTracker, this.keybindings));
        this.updateColors();
        this.updateKeyStrokes();
    }

    private void updateColors() {
        FontColorSettings fcs = (FontColorSettings)this.fontsColors.allInstances().iterator().next();
        String namePrefix = PropertiesTokenContext.context.getNamePrefix();
        Coloring keyColoring = Coloring.fromAttributeSet((AttributeSet)fcs.getTokenFontColors(namePrefix + PropertiesTokenContext.KEY.getName()));
        this.keyColor = keyColoring.getForeColor();
        this.keyBackground = keyColoring.getBackColor();
        Coloring valueColoring = Coloring.fromAttributeSet((AttributeSet)fcs.getTokenFontColors(namePrefix + PropertiesTokenContext.VALUE.getName()));
        this.valueColor = valueColoring.getForeColor();
        this.valueBackground = valueColoring.getBackColor();
        Coloring highlightColoring = Coloring.fromAttributeSet((AttributeSet)fcs.getFontColors("highlight-search"));
        this.highlightColor = highlightColoring.getForeColor();
        this.highlightBackground = highlightColoring.getBackColor();
        Coloring defaultColoring = Coloring.fromAttributeSet((AttributeSet)fcs.getFontColors("default"));
        this.font = defaultColoring.getFont();
        Color defaultForeground = defaultColoring.getForeColor();
        Color defaultBackground = defaultColoring.getBackColor();
        if (this.keyColor == null) {
            this.keyColor = defaultForeground;
        }
        if (this.keyBackground == null) {
            this.keyBackground = defaultBackground;
        }
        if (this.valueColor == null) {
            this.valueColor = defaultForeground;
        }
        if (this.valueBackground == null) {
            this.valueBackground = defaultBackground;
        }
        if (this.highlightColor == null) {
            this.highlightColor = new Color(SystemColor.textHighlightText.getRGB());
        }
        if (this.highlightBackground == null) {
            this.highlightBackground = new Color(SystemColor.textHighlight.getRGB());
        }
        if (this.shadowColor == null) {
            this.shadowColor = new Color(SystemColor.controlHighlight.getRGB());
        }
    }

    private void updateKeyStrokes() {
        KeyBindingSettings kbs = (KeyBindingSettings)this.keybindings.allInstances().iterator().next();
        HashSet<KeyStroke> nextKS = new HashSet<KeyStroke>();
        HashSet<KeyStroke> prevKS = new HashSet<KeyStroke>();
        HashSet<KeyStroke> toggleKS = new HashSet<KeyStroke>();
        for (MultiKeyBinding mkb : kbs.getKeyBindings()) {
            int k;
            if (mkb.getActionName().equals("find-next")) {
                for (k = 0; k < mkb.getKeyStrokeCount(); ++k) {
                    nextKS.add(mkb.getKeyStroke(k));
                }
            }
            if (mkb.getActionName().equals("find-previous")) {
                for (k = 0; k < mkb.getKeyStrokeCount(); ++k) {
                    prevKS.add(mkb.getKeyStroke(k));
                }
            }
            if (!mkb.getActionName().equals("toggle-highlight-search")) continue;
            for (k = 0; k < mkb.getKeyStrokeCount(); ++k) {
                toggleKS.add(mkb.getKeyStroke(k));
            }
        }
        this.keyStrokesFindNext = new KeyStroke[nextKS.size()];
        nextKS.toArray(this.keyStrokesFindNext);
        this.keyStrokesFindPrevious = new KeyStroke[prevKS.size()];
        prevKS.toArray(this.keyStrokesFindPrevious);
        this.keyStrokesToggleHighlight = new KeyStroke[toggleKS.size()];
        toggleKS.toArray(this.keyStrokesToggleHighlight);
        this.settingsUpdated();
    }
}

