/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.actions;

import java.awt.Image;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.spi.actions.ContextAction;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;

public abstract class LookupProviderAction<T extends Lookup.Provider, R>
extends ContextAction<T> {
    private final Class<R> delegateType;
    private final boolean all;
    final ContextAction<R> overDelegateType;
    private boolean inDelegate;

    protected LookupProviderAction(Class<T> type, Class<R> delegateType, boolean all) {
        super(type);
        assert (delegateType != null);
        this.delegateType = delegateType;
        this.all = all;
        this.overDelegateType = new InternalDelegateAction(delegateType);
    }

    protected LookupProviderAction(Class<T> type, Class<R> delegateType, boolean all, String displayName, Image icon) {
        super(type, displayName, icon);
        assert (delegateType != null);
        this.delegateType = delegateType;
        this.all = all;
        this.overDelegateType = new InternalDelegateAction(delegateType);
    }

    @Override
    protected final void actionPerformed(Collection<? extends T> targets) {
        if (this.all) {
            Set<R> delegates = this.delegates(targets);
            assert (delegates != null && !delegates.isEmpty());
        }
        Action contextDelegate = this.overDelegateType.createContextAwareInstance(this.delegateLookup());
        assert (contextDelegate.isEnabled());
        contextDelegate.actionPerformed(null);
    }

    @Override
    protected boolean checkQuantity(int lookupProviderCount) {
        return lookupProviderCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Lookup delegateLookup() {
        this.inDelegate = true;
        try {
            LinkedList<Lookup> lookups = new LinkedList<Lookup>();
            Collection sc = super.getStub().collection();
            assert (sc != null);
            for (Lookup.Provider provider : sc) {
                lookups.add(provider.getLookup());
            }
            Lookup[] lkps = lookups.toArray(new Lookup[0]);
            ProxyLookup proxyLookup = new ProxyLookup(lkps);
            return proxyLookup;
        }
        finally {
            this.inDelegate = false;
        }
    }

    private Set<? extends R> delegates(Collection<? extends T> targets) {
        HashSet realTargets = new HashSet();
        for (Lookup.Provider provider : targets) {
            Collection delegateCookies = provider.getLookup().lookupAll(this.delegateType);
            if (this.all && delegateCookies.isEmpty()) {
                return null;
            }
            realTargets.addAll(delegateCookies);
        }
        return realTargets;
    }

    protected abstract void perform(Collection<? extends R> var1);

    protected boolean enabled(Collection<? extends R> targets) {
        return true;
    }

    @Override
    protected final boolean isEnabled(Collection<? extends T> targets) {
        Set<R> delegates;
        if (this.inDelegate) {
            return true;
        }
        boolean result = this.all ? (delegates = this.delegates(targets)) != null && !delegates.isEmpty() : true;
        if (result) {
            result = this.overDelegateType.createContextAwareInstance(this.delegateLookup()).isEnabled();
        }
        return result;
    }

    private class InternalDelegateAction
    extends ContextAction<R> {
        public InternalDelegateAction(Class<R> type) {
            super(type);
        }

        @Override
        protected void actionPerformed(Collection<? extends R> targets) {
            LookupProviderAction.this.perform(targets);
        }

        @Override
        protected boolean isEnabled(Collection<? extends R> targets) {
            return LookupProviderAction.this.enabled(targets);
        }

        @Override
        public Object getValue(String key) {
            Object result = super.getValue(key);
            if (result == null) {
                result = LookupProviderAction.this.getValue(key);
            }
            return result;
        }
    }
}

