/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ant;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.hudson.ant.AntBasedJobCreator;
import org.netbeans.modules.hudson.ant.Bundle;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.ui.spi.ProjectHudsonJobCreatorFactory;
import org.netbeans.modules.java.api.common.project.ui.customizer.ProjectSharability;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class JobCreator
extends JPanel
implements ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator {
    private final Project project;
    private final AntBasedJobCreator.Configuration config;
    private final ProjectSharability shar;
    private final HudsonSCM.Configuration scm;
    private final Map<AntBasedJobCreator.Target, JCheckBox> checkboxen;

    public JobCreator(Project project, AntBasedJobCreator.Configuration config) {
        this.project = project;
        this.config = config;
        this.shar = (ProjectSharability)project.getLookup().lookup(ProjectSharability.class);
        this.scm = ProjectHudsonJobCreatorFactory.Helper.prepareSCM((File)FileUtil.toFile((FileObject)project.getProjectDirectory()));
        this.checkboxen = this.initComponents();
    }

    public String jobName() {
        return ProjectUtils.getInformation((Project)this.project).getName();
    }

    public JComponent customizer() {
        return this;
    }

    public HudsonSCM.ConfigurationStatus status() {
        if (this.scm == null) {
            return ProjectHudsonJobCreatorFactory.Helper.noSCMError();
        }
        if (this.shar != null && !this.shar.isSharable()) {
            String msg = Bundle.JobCreator_copy_message();
            JButton button = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)button, (String)Bundle.JobCreator_copy_label());
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JobCreator.this.shar.makeSharable();
                }
            });
            return HudsonSCM.ConfigurationStatus.withWarning((String)msg).withExtraButton(button);
        }
        HudsonSCM.ConfigurationStatus scmStatus = this.scm.problems();
        if (scmStatus != null) {
            return scmStatus;
        }
        return HudsonSCM.ConfigurationStatus.valid();
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }

    public Document configure() throws IOException {
        Document doc = XMLUtil.createDocument((String)"project", null, null, null);
        Element projectE = doc.getDocumentElement();
        StringBuilder targetsS = new StringBuilder();
        for (Map.Entry<AntBasedJobCreator.Target, JCheckBox> entry : this.checkboxen.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            if (targetsS.length() > 0) {
                targetsS.append(' ');
            }
            targetsS.append(entry.getKey().antName());
        }
        Element ant = (Element)projectE.appendChild(doc.createElement("builders")).appendChild(doc.createElement("hudson.tasks.Ant"));
        ant.appendChild(doc.createElement("targets")).appendChild(doc.createTextNode(targetsS.toString()));
        StringBuilder properties = null;
        for (Map.Entry<AntBasedJobCreator.Target, JCheckBox> entry : this.checkboxen.entrySet()) {
            String props;
            if (!entry.getValue().isSelected() || (props = entry.getKey().properties()) == null) continue;
            if (properties == null) {
                properties = new StringBuilder();
            } else {
                properties.append('\n');
            }
            properties.append(props);
        }
        if (properties != null) {
            ant.appendChild(doc.createElement("properties")).appendChild(doc.createTextNode(properties.toString()));
        }
        Element publishers = (Element)projectE.appendChild(doc.createElement("publishers"));
        for (Map.Entry<AntBasedJobCreator.Target, JCheckBox> entry : this.checkboxen.entrySet()) {
            String tests;
            String javadoc;
            if (!entry.getValue().isSelected()) continue;
            AntBasedJobCreator.Target t = entry.getKey();
            AntBasedJobCreator.ArchivePattern archive = t.artifactArchival();
            if (archive != null) {
                Element aa = (Element)publishers.appendChild(doc.createElement("hudson.tasks.ArtifactArchiver"));
                aa.appendChild(doc.createElement("artifacts")).appendChild(doc.createTextNode(archive.includes()));
                String excl = archive.excludes();
                if (excl != null) {
                    aa.appendChild(doc.createElement("excludes")).appendChild(doc.createTextNode(excl));
                }
                aa.appendChild(doc.createElement("latestOnly")).appendChild(doc.createTextNode("true"));
            }
            if ((javadoc = t.javadocDir()) != null) {
                publishers.appendChild(doc.createElement("hudson.tasks.JavadocArchiver")).appendChild(doc.createElement("javadocDir")).appendChild(doc.createTextNode(javadoc));
            }
            if ((tests = t.testResults()) == null) continue;
            publishers.appendChild(doc.createElement("hudson.tasks.junit.JUnitResultArchiver")).appendChild(doc.createElement("testResults")).appendChild(doc.createTextNode(tests));
        }
        for (String dummy : new String[]{"actions", "buildWrappers"}) {
            projectE.appendChild(doc.createElement(dummy));
        }
        this.scm.configure(doc);
        ProjectHudsonJobCreatorFactory.Helper.addLogRotator((Document)doc);
        return doc;
    }

    private Map<AntBasedJobCreator.Target, JCheckBox> initComponents() {
        LinkedHashMap<AntBasedJobCreator.Target, JCheckBox> boxen = new LinkedHashMap<AntBasedJobCreator.Target, JCheckBox>();
        for (AntBasedJobCreator.Target t : this.config.targets()) {
            JCheckBox box = new JCheckBox();
            boxen.put(t, box);
            box.setSelected(t.selected());
            box.setEnabled(t.enabled());
            Mnemonics.setLocalizedText((AbstractButton)box, (String)t.labelWithMnemonic());
            box.getAccessibleContext().setAccessibleDescription(Bundle.JobCreator_checkbox_a11y(t.antName()));
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        GroupLayout.ParallelGroup parallelGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        for (JCheckBox box : boxen.values()) {
            parallelGroup.addComponent(box);
        }
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(parallelGroup).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout.SequentialGroup sequentialGroup = layout.createSequentialGroup();
        boolean first = false;
        for (JCheckBox box : boxen.values()) {
            if (first) {
                first = false;
                sequentialGroup.addContainerGap();
            } else {
                sequentialGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            }
            sequentialGroup.addComponent(box);
        }
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sequentialGroup.addContainerGap(-1, Short.MAX_VALUE)));
        return boxen;
    }

    public static class Factory
    implements ProjectHudsonJobCreatorFactory {
        public ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator forProject(Project project) {
            FileObject projectXml = project.getProjectDirectory().getFileObject("nbproject/project.xml");
            if (projectXml != null && projectXml.isData()) {
                try {
                    Document doc = XMLUtil.parse((InputSource)new InputSource(projectXml.toURL().toString()), (boolean)false, (boolean)true, null, null);
                    String type = XPathFactory.newInstance().newXPath().evaluate("/*/*[local-name(.)='type']", doc.getDocumentElement());
                    for (AntBasedJobCreator handler : Lookup.getDefault().lookupAll(AntBasedJobCreator.class)) {
                        if (!handler.type().equals(type)) continue;
                        return new JobCreator(project, handler.forProject(project));
                    }
                }
                catch (Exception x) {
                    Logger.getLogger(JobCreator.class.getName()).log(Level.FINE, "Could not check type of " + projectXml, x);
                }
            }
            return null;
        }
    }
}

