/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.action.command;

import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.spi.project.ActionProvider;
import org.openide.util.Lookup;
import org.openide.util.Mutex;

public abstract class Command {
    protected final ClientSideProject project;

    public Command(ClientSideProject project) {
        assert (project != null);
        this.project = project;
    }

    public abstract String getCommandId();

    abstract boolean isActionEnabledInternal(Lookup var1);

    abstract void invokeActionInternal(Lookup var1);

    public final boolean isActionEnabled(Lookup context) {
        if (this.project.isBroken(false)) {
            return true;
        }
        return this.isActionEnabledInternal(context);
    }

    public final void invokeAction(Lookup context, AtomicBoolean warnUser) {
        if (!this.validateInvokeAction(context, warnUser)) {
            return;
        }
        this.invokeActionInternal(context);
    }

    protected boolean validateInvokeAction(Lookup context, AtomicBoolean warnUser) {
        return !this.project.isBroken(warnUser.compareAndSet(true, false));
    }

    protected static boolean isSupportedAction(String command, ActionProvider actionProvider) {
        for (String action : actionProvider.getSupportedActions()) {
            if (!command.equals(action)) continue;
            return true;
        }
        return false;
    }

    protected static void runInEventThread(Runnable task) {
        Mutex.EVENT.readAccess(task);
    }
}

