/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.openide.util.NbBundle;

public class ShellValidationStatusPanel
extends JPanel {
    private ActionListener actionListener = null;
    private JCheckBox cbRememberChoice;
    private JTextArea errorsArea;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JLabel lblDescription;
    private JLabel lblFooter;
    private JLabel lblHeader;

    public ShellValidationStatusPanel() {
        this(null, null, null);
    }

    public ShellValidationStatusPanel(Shell shell) {
        this(null, null, shell);
    }

    public ShellValidationStatusPanel(String header, String footer, Shell shell) {
        this.initComponents();
        this.lblHeader.setText(header);
        this.lblFooter.setText(footer);
        if (shell != null) {
            this.lblDescription.setText(ShellValidationStatusPanel.loc("ShellValidationStatusPanel.lblDescription.text", shell.type.name(), shell.bindir.getAbsolutePath()));
            StringBuilder errorsText = new StringBuilder();
            for (String error : shell.getValidationStatus().getErrors()) {
                errorsText.append(ShellValidationStatusPanel.loc("ShellValidationStatusPanel.error.text", new String[0]) + " " + error).append('\n');
            }
            for (String error : shell.getValidationStatus().getWarnings()) {
                errorsText.append(ShellValidationStatusPanel.loc("ShellValidationStatusPanel.warning.text", new String[0]) + " " + error).append('\n');
            }
            this.errorsArea.setText(errorsText.toString());
        }
    }

    public boolean isRememberDecision() {
        return this.cbRememberChoice.isSelected();
    }

    private void initComponents() {
        this.cbRememberChoice = new JCheckBox();
        this.lblDescription = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.errorsArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.lblHeader = new JLabel();
        this.lblFooter = new JLabel();
        this.cbRememberChoice.setText(NbBundle.getMessage(ShellValidationStatusPanel.class, (String)"ShellValidationStatusPanel.cbRememberChoice.text"));
        this.cbRememberChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShellValidationStatusPanel.this.cbRememberChoiceActionPerformed(evt);
            }
        });
        this.lblDescription.setText(NbBundle.getMessage(ShellValidationStatusPanel.class, (String)"ShellValidationStatusPanel.lblDescription.text"));
        this.errorsArea.setColumns(20);
        this.errorsArea.setEditable(false);
        this.errorsArea.setRows(5);
        this.errorsArea.setFocusable(false);
        this.errorsArea.setRequestFocusEnabled(false);
        this.jScrollPane1.setViewportView(this.errorsArea);
        this.jLabel1.setText(NbBundle.getMessage(ShellValidationStatusPanel.class, (String)"ShellValidationStatusPanel.jLabel1.text"));
        this.jLabel2.setText(NbBundle.getMessage(ShellValidationStatusPanel.class, (String)"ShellValidationStatusPanel.jLabel2.text"));
        this.lblHeader.setText(NbBundle.getMessage(ShellValidationStatusPanel.class, (String)"ShellValidationStatusPanel.lblHeader.text"));
        this.lblFooter.setText(NbBundle.getMessage(ShellValidationStatusPanel.class, (String)"ShellValidationStatusPanel.lblFooter.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblHeader).addComponent(this.lblDescription).addComponent(this.jScrollPane1, -1, 404, Short.MAX_VALUE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.cbRememberChoice).addComponent(this.lblFooter)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblHeader).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblDescription).addGap(18, 18, 18).addComponent(this.jScrollPane1, -1, 98, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.cbRememberChoice).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblFooter)));
    }

    private void cbRememberChoiceActionPerformed(ActionEvent evt) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(evt);
        }
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(ShellValidationStatusPanel.class, (String)key, (Object[])params);
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }
}

