/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.verifier;

import java.io.File;
import java.io.OutputStream;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.ui.JavaSEPlatformPanel;
import org.netbeans.modules.glassfish.common.utils.JavaUtils;
import org.netbeans.modules.glassfish.eecommon.api.VerifierSupport;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentFactory;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.j2ee.deployment.common.api.ValidationException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class VerifierImpl
extends org.netbeans.modules.j2ee.deployment.plugins.spi.VerifierSupport {
    public void verify(FileObject target, OutputStream logger) throws ValidationException {
        String jname = FileUtil.toFile((FileObject)target).getAbsolutePath();
        try {
            DeploymentManager dm = this.getAssociatedSunDM(target);
            if (dm instanceof Hk2DeploymentManager) {
                File javaHomeFile;
                Hk2DeploymentManager hk2dm = (Hk2DeploymentManager)dm;
                GlassfishModule gm = hk2dm.getCommonServerSupport();
                GlassFishServer server = gm.getInstance();
                String javaHome = (String)gm.getInstanceProperties().get("java.platform");
                if (javaHome == null || javaHome.length() < 1) {
                    javaHome = JavaUtils.getDefaultJavaHome();
                }
                if (!JavaUtils.isJavaPlatformSupported((GlassfishInstance)((GlassfishInstance)server), (File)(javaHomeFile = new File(javaHome)))) {
                    FileObject javaFO = JavaSEPlatformPanel.selectServerSEPlatform((GlassfishInstance)((GlassfishInstance)server), (File)javaHomeFile);
                    javaHome = FileUtil.toFile((FileObject)javaFO).getAbsolutePath();
                }
                VerifierSupport.launchVerifier((String)jname, (OutputStream)logger, (GlassFishServer)server, (String)javaHome);
            }
        }
        catch (DeploymentManagerCreationException ex) {
            ValidationException ve = new ValidationException("Bad DM");
            ve.initCause((Throwable)ex);
            throw ve;
        }
    }

    private DeploymentManager getAssociatedSunDM(FileObject target) throws DeploymentManagerCreationException {
        DeploymentManager dm = null;
        J2eeModuleProvider modProvider = this.getModuleProvider(target);
        if (modProvider != null) {
            InstanceProperties serverName = modProvider.getInstanceProperties();
            dm = Hk2DeploymentFactory.createEe6().getDisconnectedDeploymentManager(serverName.getProperty("url"));
        }
        return dm;
    }

    private J2eeModuleProvider getModuleProvider(FileObject target) {
        J2eeModuleProvider modProvider = null;
        Project holdingProj = FileOwnerQuery.getOwner((FileObject)target);
        if (holdingProj != null) {
            modProvider = (J2eeModuleProvider)holdingProj.getLookup().lookup(J2eeModuleProvider.class);
        }
        return modProvider;
    }
}

