/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.shortcut;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.netbeans.installer.utils.StringUtils;

public abstract class Shortcut {
    private Map<Locale, String> names;
    private Map<Locale, String> descriptions;
    private String relativePath;
    private String fileName;
    private File workingDirectory;
    private File icon;
    private int iconIndex;
    private String[] categories;
    private String path;
    private Properties properties;

    protected Shortcut(String name) {
        this.setNames(new HashMap<Locale, String>());
        this.setDescriptions(new HashMap<Locale, String>());
        this.setName(name);
        this.setCategories(new String[0]);
        this.setAdditionalProperties(new Properties());
    }

    public Map<Locale, String> getNames() {
        return this.names;
    }

    public void setNames(Map<Locale, String> names) {
        this.names = names;
    }

    public String getName() {
        return this.getName(Locale.getDefault());
    }

    public void setName(String name) {
        this.setName(name, Locale.getDefault());
    }

    public String getName(Locale locale) {
        return StringUtils.getLocalizedString(this.names, locale);
    }

    public void setName(String name, Locale locale) {
        if (name != null) {
            this.names.put(locale, name);
        } else {
            this.names.remove(locale);
        }
    }

    public Map<Locale, String> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(Map<Locale, String> comments) {
        this.descriptions = comments;
    }

    public String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public void setDescription(String description) {
        this.setDescription(description, Locale.getDefault());
    }

    public String getDescription(Locale locale) {
        return StringUtils.getLocalizedString(this.descriptions, locale);
    }

    public void setDescription(String description, Locale locale) {
        this.descriptions.put(locale, description);
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public abstract String getTargetPath();

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getWorkingDirectoryPath() {
        if (this.workingDirectory != null) {
            return this.workingDirectory.getAbsolutePath();
        }
        return null;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public File getIcon() {
        return this.icon;
    }

    public String getIconPath() {
        if (this.icon != null) {
            return this.icon.getAbsolutePath();
        }
        return null;
    }

    public void setIcon(File icon) {
        this.icon = icon;
    }

    public void setIcon(File icon, int index) {
        this.setIcon(icon);
        this.setIconIndex(index);
    }

    public String[] getCategories() {
        return this.categories;
    }

    public void setCategories(String[] categories) {
        this.categories = categories;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    public void setIconIndex(int iconIndex) {
        this.iconIndex = iconIndex;
    }

    public Properties getAdditionalProperties() {
        return this.properties;
    }

    public void setAdditionalProperties(Properties props) {
        this.properties = props;
    }

    public void setAdditionalProperty(String propName, String propValue) {
        this.properties.put(propName, propValue);
    }
}

