/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.downloader.queue;

import java.io.File;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.installer.downloader.DownloadManager;
import org.netbeans.installer.downloader.Pumping;
import org.netbeans.installer.downloader.dispatcher.ProcessDispatcher;
import org.netbeans.installer.downloader.dispatcher.impl.RoundRobinDispatcher;
import org.netbeans.installer.downloader.impl.Pump;
import org.netbeans.installer.downloader.impl.PumpingImpl;
import org.netbeans.installer.downloader.queue.QueueBase;

public class DispatchedQueue
extends QueueBase {
    private final ProcessDispatcher dispatcher = new RoundRobinDispatcher(100, 10);
    private final Map<String, Pump> pId2p = new LinkedHashMap<String, Pump>();

    public DispatchedQueue(File stateFile) {
        super(stateFile);
    }

    @Override
    public synchronized void reset() {
        boolean wasActive = this.dispatcher.isActive();
        this.terminate();
        for (String id : this.id2Pumping.keySet().toArray(new String[0])) {
            this.delete(id);
        }
        this.fire("queueReset", new Object[0]);
        if (wasActive) {
            this.invoke();
        }
    }

    @Override
    public synchronized Pumping add(URL url) {
        return this.add(url, DownloadManager.instance.defaultFolder());
    }

    @Override
    public synchronized Pumping add(URL url, File folder) {
        PumpingImpl newOne = new PumpingImpl(url, folder, this);
        String id = newOne.getId();
        this.id2Pumping.put(id, newOne);
        if (this.dispatcher.isActive()) {
            Pump pump = new Pump(newOne);
            this.pId2p.put(id, pump);
            this.dispatcher.schedule(pump);
        }
        this.fire("pumpingAdd", id);
        return newOne;
    }

    @Override
    public synchronized Pumping delete(String id) {
        PumpingImpl oldOne = (PumpingImpl)this.id2Pumping.remove(id);
        if (oldOne == null) {
            return null;
        }
        this.dispatcher.terminate(this.pId2p.get(id));
        this.fire("pumpingDelete", id);
        this.pId2p.remove(id);
        if (oldOne.state() != Pumping.State.FINISHED) {
            oldOne.reset();
        }
        return oldOne;
    }

    @Override
    public synchronized void delete(URL url) {
        for (Pumping pumping : this.toArray()) {
            if (pumping.declaredURL() != url) continue;
            this.delete(pumping.getId());
        }
    }

    public synchronized void invoke() {
        if (this.dispatcher.isActive()) {
            return;
        }
        this.fire("pumpsInvoke", new Object[0]);
        for (Pumping pumping : this.toArray()) {
            if (pumping.state() == Pumping.State.FINISHED) continue;
            Pump newOne = new Pump(pumping);
            this.pId2p.put(pumping.getId(), newOne);
            this.dispatcher.schedule(newOne);
        }
        this.dispatcher.start();
    }

    public synchronized void terminate() {
        if (!this.dispatcher.isActive()) {
            return;
        }
        this.dispatcher.stop();
        this.dump();
        this.fire("pumpsTerminate", new Object[0]);
    }

    public synchronized boolean isActive() {
        return this.dispatcher.isActive();
    }
}

