/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.downloader.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.installer.downloader.DownloadMode;
import org.netbeans.installer.downloader.Pumping;
import org.netbeans.installer.downloader.impl.PumpingUtil;
import org.netbeans.installer.downloader.impl.SectionImpl;
import org.netbeans.installer.downloader.queue.QueueBase;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.exceptions.ParseException;
import org.netbeans.installer.utils.xml.DomExternalizable;
import org.netbeans.installer.utils.xml.DomUtil;
import org.netbeans.installer.utils.xml.visitors.DomVisitor;
import org.netbeans.installer.utils.xml.visitors.RecursiveDomVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PumpingImpl
implements Pumping,
DomExternalizable {
    private static int nextId;
    private final transient String id;
    private final QueueBase queue;
    protected URL url;
    protected URL realUrl;
    protected File folder;
    protected File file;
    protected long length = -2L;
    protected boolean acceptBytes = false;
    protected Date lastModif = new Date(0L);
    protected List<SectionImpl> sections = new LinkedList<SectionImpl>();
    protected Pumping.State state = Pumping.State.NOT_PROCESSED;
    protected DownloadMode mode = DownloadMode.SINGLE_THREAD;

    public PumpingImpl(URL url, File folder, QueueBase queue) {
        this(queue);
        this.url = url;
        this.folder = folder;
    }

    public PumpingImpl(QueueBase queue) {
        this.id = this.getClass().getName() + nextId++;
        this.queue = queue;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public URL declaredURL() {
        return this.url;
    }

    @Override
    public URL realURL() {
        return this.realUrl;
    }

    @Override
    public File outputFile() {
        return this.file;
    }

    @Override
    public File folder() {
        return this.folder;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public DownloadMode mode() {
        return this.mode;
    }

    @Override
    public Pumping.State state() {
        return this.state;
    }

    public void changeState(Pumping.State newState) {
        this.state = newState;
        this.fireChanges("pumpingStateChange");
    }

    @Override
    public Pumping.Section[] getSections() {
        return this.sections.toArray(new Pumping.Section[this.sections.size()]);
    }

    public void fireChanges(String method) {
        this.queue.fire(method, this.id);
    }

    public SectionImpl getSection() {
        if (this.mode == DownloadMode.SINGLE_THREAD || !this.acceptBytes) {
            if (this.sections.isEmpty()) {
                this.sections.add(new SectionImpl(this, 0L, this.length));
            }
            return this.sections.get(0);
        }
        throw new UnsupportedOperationException("multi mode not supported yet!");
    }

    @Override
    public void readXML(Element element) {
        RecursiveDomVisitor visitor = new RecursiveDomVisitor(){

            @Override
            public void visit(Element element) {
                String name = element.getNodeName();
                if ("url".equals(name)) {
                    try {
                        PumpingImpl.this.url = StringUtils.parseUrl(element.getTextContent());
                    }
                    catch (ParseException e) {
                        ErrorManager.notifyDebug("Could not parse URL", e);
                    }
                } else if ("realUrl".equals(name)) {
                    try {
                        PumpingImpl.this.realUrl = StringUtils.parseUrl(element.getTextContent());
                    }
                    catch (ParseException e) {
                        ErrorManager.notifyDebug("Could not parse URL", e);
                    }
                } else if ("length".equals(name)) {
                    PumpingImpl.this.length = Long.valueOf(element.getTextContent());
                } else if ("lastModif".equals(name)) {
                    PumpingImpl.this.lastModif = new Date(Long.valueOf(element.getTextContent()));
                } else if ("acceptBytes".equals(name)) {
                    PumpingImpl.this.acceptBytes = Boolean.valueOf(element.getTextContent());
                } else if ("state".equals(name)) {
                    PumpingImpl.this.state = Pumping.State.valueOf(element.getTextContent());
                } else if ("file".equals(name)) {
                    if (!"".equals(element.getTextContent().trim())) {
                        PumpingImpl.this.file = new File(element.getTextContent());
                    }
                } else if ("folder".equals(name)) {
                    PumpingImpl.this.folder = new File(element.getTextContent());
                } else if ("section".equals(name)) {
                    SectionImpl section = new SectionImpl(PumpingImpl.this);
                    section.readXML(element);
                    PumpingImpl.this.sections.add(section);
                } else {
                    super.visit(element);
                }
            }
        };
        ((DomVisitor)visitor).visit(element);
    }

    @Override
    public Element writeXML(Document document) {
        Element root = document.createElement("pumping");
        DomUtil.addElement(root, "url", this.url.toString());
        DomUtil.addElement(root, "realUrl", this.realUrl != null ? this.realUrl.toString() : null);
        DomUtil.addElement(root, "length", String.valueOf(this.length));
        DomUtil.addElement(root, "lastModif", String.valueOf(this.lastModif.getTime()));
        DomUtil.addElement(root, "acceptBytes", String.valueOf(this.acceptBytes));
        DomUtil.addElement(root, "state", this.state.toString());
        DomUtil.addElement(root, "file", this.file != null ? this.file.getAbsolutePath() : null);
        DomUtil.addElement(root, "folder", this.folder.getAbsolutePath());
        for (SectionImpl section : this.sections) {
            DomUtil.addChild(root, section);
        }
        return root;
    }

    public void init(URL realUrl, long length, Date lastModif, boolean acceptBytes) throws IOException {
        if (this.wasModified(realUrl, length, lastModif, acceptBytes)) {
            this.reset();
            this.realUrl = realUrl;
            this.length = length;
            this.acceptBytes = acceptBytes;
            if (lastModif != null) {
                this.lastModif = lastModif;
            }
            this.file = PumpingUtil.getFileNameFromURL(this.folder, this.realUrl.getPath());
            if (this.file.getParentFile() != null) {
                this.file.getParentFile().mkdirs();
            }
            this.file.createNewFile();
        }
    }

    public void reset() {
        this.realUrl = null;
        this.length = -2L;
        this.acceptBytes = false;
        this.lastModif = new Date(0L);
        this.sections = new LinkedList<SectionImpl>();
        if (this.file != null) {
            this.file.delete();
        }
    }

    protected boolean wasModified(URL realUrl, long length, Date lastModif, boolean acceptBytes) {
        if (this.realUrl == null || !this.realUrl.equals(realUrl)) {
            return true;
        }
        if (this.length == -2L || this.length != length) {
            return true;
        }
        if (lastModif != null && this.lastModif.before(lastModif)) {
            return true;
        }
        return this.acceptBytes != acceptBytes;
    }
}

