/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.downloader;

import java.io.File;
import org.netbeans.installer.downloader.DownloadListener;
import org.netbeans.installer.downloader.PumpingsQueue;
import org.netbeans.installer.downloader.queue.DispatchedQueue;
import org.netbeans.installer.utils.helper.FinishHandler;

public class DownloadManager {
    public static final DownloadManager instance = new DownloadManager();
    private File localDirectory;
    private FinishHandler finishHandler;
    private File defaultFolder;
    private DispatchedQueue queue;
    private File wd;
    public static final String DOWNLOADS_DIR_NAME = "downloads";
    public static final String WD_DIR_NAME = "wd";
    public static final String STATE_FILE_NAME = "state.xml";

    public static DownloadManager getInstance() {
        return instance;
    }

    private DownloadManager() {
    }

    public void init() {
        this.defaultFolder = new File(this.localDirectory, DOWNLOADS_DIR_NAME);
        this.defaultFolder.mkdirs();
        this.wd = new File(this.localDirectory, WD_DIR_NAME);
        this.wd.mkdirs();
        this.queue = new DispatchedQueue(new File(this.wd, STATE_FILE_NAME));
        this.queue.reset();
    }

    public PumpingsQueue queue() {
        return this.queue;
    }

    public void registerListener(DownloadListener listener) {
        this.queue.addListener(listener);
    }

    public void invoke() {
        this.queue.invoke();
    }

    public void terminate() {
        this.queue.terminate();
    }

    public boolean isActive() {
        return this.queue.isActive();
    }

    public File getWd() {
        return this.wd;
    }

    public File defaultFolder() {
        return this.defaultFolder;
    }

    public File getLocalDirectory() {
        return this.localDirectory;
    }

    public void setLocalDirectory(File localDirectory) {
        this.localDirectory = localDirectory;
    }

    public FinishHandler getFinishHandler() {
        return this.finishHandler;
    }

    public void setFinishHandler(FinishHandler finishHandler) {
        this.finishHandler = finishHandler;
    }
}

