/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl;

import java.net.URI;
import java.net.URISyntaxException;
import org.netbeans.modules.xml.schema.model.Constraint;
import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.KeyRef;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.impl.ConstraintImpl;
import org.netbeans.modules.xml.schema.model.impl.SchemaAttributes;
import org.netbeans.modules.xml.schema.model.impl.SchemaElements;
import org.netbeans.modules.xml.schema.model.impl.SchemaModelImpl;
import org.netbeans.modules.xml.schema.model.visitor.FindReferredConstraintVisitor;
import org.netbeans.modules.xml.schema.model.visitor.SchemaVisitor;

public class KeyRefImpl
extends ConstraintImpl
implements KeyRef {
    public KeyRefImpl(SchemaModelImpl model) {
        this(model, KeyRefImpl.createNewComponent(SchemaElements.KEYREF, model));
    }

    public KeyRefImpl(SchemaModelImpl model, org.w3c.dom.Element el) {
        super(model, el);
    }

    @Override
    public Class<? extends SchemaComponent> getComponentType() {
        return KeyRef.class;
    }

    @Override
    public void setReferer(Constraint c) {
        this.setAttribute("referer", SchemaAttributes.REFER, c == null ? null : new ConstraintWrapper(c));
    }

    @Override
    public void accept(SchemaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Constraint getReferer() {
        String referValue = this.getAttribute(SchemaAttributes.REFER);
        if (referValue == null) {
            return null;
        }
        String localName = this.getLocalName(referValue);
        SchemaComponent parent = this.findOutermostParentElement();
        FindReferredConstraintVisitor visitor = new FindReferredConstraintVisitor();
        return visitor.findReferredConstraint(parent, localName);
    }

    private String getLocalName(String uri) {
        String localName = null;
        try {
            URI u = new URI(uri);
            localName = u.getSchemeSpecificPart();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return localName;
    }

    private SchemaComponent findOutermostParentElement() {
        SchemaComponent element = null;
        for (SchemaComponent sc = (SchemaComponent)this.getParent(); sc != null; sc = (SchemaComponent)sc.getParent()) {
            if (!(sc instanceof Element)) continue;
            element = sc;
        }
        return element;
    }

    private static class ConstraintWrapper {
        private Constraint c;

        public ConstraintWrapper(Constraint c) {
            this.c = c;
        }

        public String toString() {
            return this.c.getName();
        }
    }
}

