/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.dists.api;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;

public final class GradleDistProject {
    final File projectDir;
    final Set<String> distributions;

    GradleDistProject(File projectDir, Set<String> distributions) {
        this.projectDir = projectDir;
        this.distributions = distributions;
    }

    public Set<String> getDistributions() {
        return this.distributions != null ? this.distributions : Collections.emptySet();
    }

    public Set<String> getAvailableDistributions() {
        return this.getDistributions().stream().filter(dist -> this.getDistributionSource((String)dist).isDirectory()).collect(Collectors.toSet());
    }

    public File getDistributionSource(String distribution) {
        File src = new File(this.projectDir, "src");
        File dist = new File(src, distribution);
        return new File(dist, "dist");
    }

    public static GradleDistProject get(Project project) {
        NbGradleProject gp = NbGradleProject.get((Project)project);
        return gp != null ? (GradleDistProject)gp.projectLookup(GradleDistProject.class) : null;
    }
}

