/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.modules.java.api.common.impl.MultiModule;
import org.netbeans.modules.java.api.common.queries.EvaluatorPropertyProvider;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.ChangeSupport;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

final class MultiModuleBinaryForSourceQueryImpl
implements BinaryForSourceQueryImplementation,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(MultiModuleBinaryForSourceQueryImpl.class.getName());
    private static final URL[] EMPTY = new URL[0];
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final MultiModule modules;
    private final MultiModule testModules;
    private final String[] binaryTemplates;
    private final String[] testBinaryTemplates;
    private final ConcurrentMap<URI, R> cache;

    MultiModuleBinaryForSourceQueryImpl(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator evaluator, @NonNull MultiModule modules, @NonNull MultiModule testModules, @NonNull String[] binaryTemplates, @NonNull String[] testBinaryTemplates) {
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
        Parameters.notNull((CharSequence)"modules", (Object)modules);
        Parameters.notNull((CharSequence)"testModules", (Object)testModules);
        Parameters.notNull((CharSequence)"binaryTemplates", (Object)binaryTemplates);
        Parameters.notNull((CharSequence)"testBinaryTemplates", (Object)testBinaryTemplates);
        this.helper = helper;
        this.evaluator = evaluator;
        this.modules = modules;
        this.testModules = testModules;
        this.binaryTemplates = binaryTemplates;
        this.testBinaryTemplates = testBinaryTemplates;
        this.cache = new ConcurrentHashMap<URI, R>();
        this.modules.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.modules));
        this.testModules.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.testModules));
    }

    public BinaryForSourceQuery.Result findBinaryRoots(URL sourceRoot) {
        R res = null;
        try {
            URI sourceRootURI = sourceRoot.toURI();
            res = (R)this.cache.get(sourceRootURI);
            if (res == null) {
                R prev;
                res = this.createResult(sourceRoot, this.modules, this.binaryTemplates);
                if (res == null) {
                    res = this.createResult(sourceRoot, this.testModules, this.testBinaryTemplates);
                }
                if ((prev = (R)this.cache.get(sourceRootURI)) != null) {
                    res = prev;
                } else if (res != null && (prev = this.cache.putIfAbsent(sourceRootURI, res)) != null) {
                    res = prev;
                }
            }
        }
        catch (URISyntaxException e) {
            LOG.log(Level.WARNING, "Invalid URI: {0}", sourceRoot.toExternalForm());
        }
        return res;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block3: {
            Object source;
            block2: {
                source = evt.getSource();
                if (source != this.modules) break block2;
                Iterator it = this.cache.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    R r = (R)e.getValue();
                    if (r.isValid(this.modules)) continue;
                    it.remove();
                }
                break block3;
            }
            if (source != this.testModules) break block3;
            Iterator it = this.cache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                R r = (R)e.getValue();
                if (r.isValid(this.testModules)) continue;
                it.remove();
            }
        }
    }

    @CheckForNull
    private R createResult(@NonNull URL artifact, @NonNull MultiModule modules, @NonNull String[] templates) {
        for (String string : modules.getModuleNames()) {
            ClassPath scp = modules.getModuleSources(string);
            if (scp == null) continue;
            for (ClassPath.Entry e : scp.entries()) {
                if (!artifact.equals(e.getURL())) continue;
                return new R(artifact, modules, string, templates);
            }
        }
        return null;
    }

    private final class R
    implements BinaryForSourceQuery.Result,
    PropertyChangeListener {
        private final URL url;
        private final EvaluatorPropertyProvider pp;
        private final PropertyEvaluator evaluator;
        private final MultiModule modules;
        private final String moduleName;
        private final String[] templates;
        private final AtomicReference<URL[]> cache;
        private final ChangeSupport listeners;
        private final AtomicReference<Set<String>> propsCache;
        private final AtomicReference<Pair<ClassPath, PropertyChangeListener>> scp;

        R(@NonNull URL url, @NonNull MultiModule modules, @NonNull String moduleName, String[] templates) {
            Parameters.notNull((CharSequence)"url", (Object)url);
            Parameters.notNull((CharSequence)"modules", (Object)modules);
            Parameters.notNull((CharSequence)"moduleName", (Object)moduleName);
            Parameters.notNull((CharSequence)"templates", (Object)templates);
            this.url = url;
            this.pp = new EvaluatorPropertyProvider(MultiModuleBinaryForSourceQueryImpl.this.evaluator);
            this.evaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)PropertyUtils.fixedPropertyProvider(Collections.singletonMap("module.name", moduleName)), (PropertyProvider[])new PropertyProvider[]{this.pp});
            this.modules = modules;
            this.moduleName = moduleName;
            this.templates = templates;
            this.cache = new AtomicReference();
            this.listeners = new ChangeSupport((Object)this);
            this.propsCache = new AtomicReference();
            this.scp = new AtomicReference();
            MultiModuleBinaryForSourceQueryImpl.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)MultiModuleBinaryForSourceQueryImpl.this.evaluator));
            this.modules.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.modules));
        }

        public URL[] getRoots() {
            URL[] res = this.cache.get();
            if (res == null) {
                try {
                    if (this.isSourceRoot()) {
                        PropertyChangeListener l;
                        ClassPath cp;
                        Pair cplp = this.scp.get();
                        if (cplp == null && this.scp.compareAndSet(null, (Pair<ClassPath, PropertyChangeListener>)(cplp = Pair.of((Object)(cp = this.modules.getModuleSources(this.moduleName)), (Object)(l = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)cp)))))) {
                            cp.addPropertyChangeListener(l);
                        }
                        res = new URL[this.templates.length];
                        for (int i = 0; i < this.templates.length; ++i) {
                            File f = MultiModuleBinaryForSourceQueryImpl.this.helper.resolveFile(this.evaluator.evaluate(this.templates[i]));
                            URL u = BaseUtilities.toURI((File)f).toURL();
                            String su = u.toExternalForm();
                            if (su.length() > 4 && ".jar".equals(su.substring(su.length() - 4).toLowerCase(Locale.ENGLISH))) {
                                u = FileUtil.getArchiveRoot((URL)u);
                            } else if (!su.endsWith("/")) {
                                u = new URL(su + '/');
                            }
                            res[i] = u;
                        }
                    } else {
                        res = EMPTY;
                    }
                }
                catch (MalformedURLException e) {
                    res = new URL[]{};
                }
                this.cache.set(res);
            }
            return Arrays.copyOf(res, res.length);
        }

        public void addChangeListener(ChangeListener l) {
            this.listeners.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.listeners.removeChangeListener(l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            String propName = evt.getPropertyName();
            if (source == this.modules) {
                if (!this.isSourceRoot()) {
                    this.cache.set(null);
                    Pair<ClassPath, PropertyChangeListener> cplp = this.scp.get();
                    if (cplp != null && this.scp.compareAndSet(cplp, null)) {
                        ((ClassPath)cplp.first()).removePropertyChangeListener((PropertyChangeListener)cplp.second());
                    }
                    this.listeners.fireChange();
                }
            } else if (source == Optional.ofNullable(this.scp.get()).map(p -> (ClassPath)p.first()).orElse(null) && "entries".equals(propName)) {
                if (!this.isSourceRoot()) {
                    this.cache.set(null);
                    MultiModuleBinaryForSourceQueryImpl.this.propertyChange(new PropertyChangeEvent(this.modules, "entries", null, null));
                    this.listeners.fireChange();
                }
            } else if (propName == null || this.getImportantProperties().contains(propName)) {
                this.pp.update();
                this.cache.set(null);
                this.listeners.fireChange();
            }
        }

        boolean isValid(@NonNull MultiModule model) {
            if (model != this.modules) {
                return true;
            }
            return this.isSourceRoot();
        }

        private boolean isSourceRoot() {
            ClassPath cp = this.modules.getModuleSources(this.moduleName);
            if (cp == null) {
                return false;
            }
            for (ClassPath.Entry e : cp.entries()) {
                if (!e.getURL().equals(this.url)) continue;
                return true;
            }
            return false;
        }

        @NonNull
        private Set<? extends String> getImportantProperties() {
            Set<String> res = this.propsCache.get();
            if (res == null) {
                res = new HashSet<String>();
                for (String template : this.templates) {
                    int propStart = -2;
                    block9: for (int i = 0; i < template.length(); ++i) {
                        char c = template.charAt(i);
                        switch (propStart) {
                            case -2: {
                                if (c != '$') continue block9;
                                propStart = -1;
                                continue block9;
                            }
                            case -1: {
                                switch (c) {
                                    case '{': {
                                        propStart = i + 1;
                                        continue block9;
                                    }
                                    case '$': {
                                        propStart = -1;
                                        continue block9;
                                    }
                                }
                                propStart = -2;
                                continue block9;
                            }
                            default: {
                                if (c != '}') continue block9;
                                String propName = template.substring(propStart, i);
                                res.add(propName);
                                propStart = -2;
                            }
                        }
                    }
                }
                this.propsCache.set(res);
            }
            return res;
        }
    }
}

