/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ModuleRoots
extends SourceRoots {
    public static final String DEFAULT_MODULE_LABEL = NbBundle.getMessage(ModuleRoots.class, (String)"NAME_module.dir");
    public static final String DEFAULT_TEST_MODULE_LABEL = NbBundle.getMessage(ModuleRoots.class, (String)"NAME_test.module.dir");
    private static final String DEFAULT_MODULE_PATH = "classes";
    private static final String DEFAULT_TEST_MODULE_PATH = "tests";
    private static final String DEFAULT_PATH_TEMPLATE = "{0}{1}.path";

    public static ModuleRoots create(UpdateHelper helper, PropertyEvaluator evaluator, ReferenceHelper refHelper, String projectConfigurationNamespace, String elementName, boolean isTest, String newRootNameTemplate) {
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
        Parameters.notNull((CharSequence)"refHelper", (Object)refHelper);
        Parameters.notNull((CharSequence)"projectConfigurationNamespace", (Object)projectConfigurationNamespace);
        Parameters.notNull((CharSequence)"elementName", (Object)elementName);
        Parameters.notNull((CharSequence)"newRootNameTemplate", (Object)newRootNameTemplate);
        return new ModuleRoots(helper, evaluator, refHelper, projectConfigurationNamespace, elementName, "modules", isTest, newRootNameTemplate);
    }

    private ModuleRoots(UpdateHelper helper, PropertyEvaluator evaluator, ReferenceHelper refHelper, String projectConfigurationNamespace, String elementName, String type, boolean isTest, String newRootNameTemplate) {
        super(helper, evaluator, refHelper, projectConfigurationNamespace, elementName, type, isTest, newRootNameTemplate);
    }

    @Override
    public String[] getRootPathProperties() {
        return super.getRootPathProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL[] getRootURLs(boolean removeInvalidRoots) {
        ModuleRoots moduleRoots = this;
        synchronized (moduleRoots) {
            if (this.sourceRootURLs != null) {
                return this.sourceRootURLs.toArray(new URL[this.sourceRootURLs.size()]);
            }
        }
        return (URL[])ProjectManager.mutex().readAccess(() -> {
            ModuleRoots moduleRoots = this;
            synchronized (moduleRoots) {
                if (this.sourceRootURLs == null) {
                    ArrayList<URL> result = new ArrayList<URL>();
                    for (String rootProp : this.getRootProperties()) {
                        String pathToRoot = this.evaluator.getProperty(rootProp);
                        if (pathToRoot == null) continue;
                        File file = this.helper.getAntProjectHelper().resolveFile(pathToRoot);
                        try {
                            URL url = Utilities.toURI((File)file).toURL();
                            if (!file.exists()) {
                                url = new URL(url.toExternalForm() + "/");
                            } else if (removeInvalidRoots && !file.isDirectory()) continue;
                            assert (url.toExternalForm().endsWith("/")) : "#90639 violation for " + url + "; " + file + " exists? " + file.exists() + " dir? " + file.isDirectory() + " file? " + file.isFile();
                            result.add(url);
                            this.listener.add(file, false);
                        }
                        catch (MalformedURLException e) {
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    }
                    this.sourceRootURLs = Collections.unmodifiableList(result);
                }
                return this.sourceRootURLs.toArray(new URL[this.sourceRootURLs.size()]);
            }
        });
    }

    public void putModuleRoots(URL[] roots, String[] paths) {
        ProjectManager.mutex().writeAccess(() -> {
            Map<URL, Pair<String, String>> oldRoots2props = this.getRootsToProps();
            HashMap<URL, String> newRoots2paths = new HashMap<URL, String>();
            for (int i = 0; i < roots.length; ++i) {
                newRoots2paths.put(roots[i], paths[i]);
            }
            Element cfgEl = this.helper.getPrimaryConfigurationData(true);
            NodeList nl = cfgEl.getElementsByTagNameNS(this.projectConfigurationNamespace, this.elementName);
            if (nl.getLength() != 1) {
                FileObject prjDir = this.helper.getAntProjectHelper().getProjectDirectory();
                FileObject projectXml = prjDir == null ? null : prjDir.getFileObject("nbproject/project.xml");
                String content = null;
                try {
                    content = projectXml == null ? null : projectXml.asText("UTF-8");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new IllegalArgumentException(String.format("Broken nbproject/project.xml, missing %s in %s namespace, content: %s.", this.elementName, this.projectConfigurationNamespace, content));
            }
            Element ownerElement = (Element)nl.item(0);
            NodeList rootsNodes = ownerElement.getElementsByTagNameNS(this.projectConfigurationNamespace, "root");
            while (rootsNodes.getLength() > 0) {
                Element root = (Element)rootsNodes.item(0);
                ownerElement.removeChild(root);
            }
            List<URL> newRoots = Arrays.asList(roots);
            HashMap<URL, Pair<String, String>> propsToRemove = new HashMap<URL, Pair<String, String>>(oldRoots2props);
            propsToRemove.keySet().removeAll(newRoots);
            EditableProperties ep = this.helper.getProperties("nbproject/project.properties");
            HashSet referencesToRemove = new HashSet();
            propsToRemove.values().stream().forEach(propToRemove -> {
                String propValue = ep.getProperty((String)propToRemove.first());
                if (propValue != null && propValue.startsWith("${file.reference.")) {
                    referencesToRemove.add(propValue);
                }
                ep.remove(propToRemove.first());
                ep.remove(propToRemove.second());
            });
            this.helper.putProperties("nbproject/project.properties", ep);
            referencesToRemove.stream().filter(referenceToRemove -> !ModuleRoots.isUsed(referenceToRemove, ep)).forEach(referenceToRemove -> this.refHelper.destroyReference(referenceToRemove));
            Document doc = ownerElement.getOwnerDocument();
            oldRoots2props.keySet().retainAll(newRoots);
            newRoots.stream().map(newRoot -> {
                Pair props = (Pair)oldRoots2props.get(newRoot);
                if (props == null) {
                    String prjPath;
                    String[] names = newRoot.getPath().split("/");
                    String rootName = MessageFormat.format(this.newRootNameTemplate, names[names.length - 1], "");
                    int rootIndex = 1;
                    while (ep.containsKey((Object)rootName)) {
                        rootName = MessageFormat.format(this.newRootNameTemplate, names[names.length - 1], ++rootIndex);
                    }
                    File f = FileUtil.normalizeFile((File)Utilities.toFile((URI)URI.create(newRoot.toExternalForm())));
                    File projDir = FileUtil.toFile((FileObject)this.helper.getAntProjectHelper().getProjectDirectory());
                    String path = f.getAbsolutePath();
                    path = path.startsWith(prjPath = projDir.getAbsolutePath() + File.separatorChar) ? path.substring(prjPath.length()) : this.refHelper.createForeignFileReference(f, "java");
                    ep.put(rootName, path);
                    String rootPath = MessageFormat.format(DEFAULT_PATH_TEMPLATE, rootName, "");
                    rootIndex = 1;
                    while (ep.containsKey((Object)rootPath)) {
                        rootPath = MessageFormat.format(DEFAULT_PATH_TEMPLATE, rootName, ++rootIndex);
                    }
                    ep.put(rootPath, (String)newRoots2paths.get(newRoot));
                    this.helper.putProperties("nbproject/project.properties", ep);
                    props = Pair.of((Object)rootName, (Object)rootPath);
                }
                Element newRootNode = doc.createElementNS(this.projectConfigurationNamespace, "root");
                newRootNode.setAttribute("id", (String)props.first());
                String path = (String)props.second();
                if (path != null && path.length() > 0) {
                    newRootNode.setAttribute("pathref", path);
                }
                return newRootNode;
            }).forEachOrdered(newRootNode -> ownerElement.appendChild((Node)newRootNode));
            this.helper.putPrimaryConfigurationData(cfgEl, true);
        });
    }

    @Override
    public String getRootDisplayName(String rootName, String propName) {
        if (rootName == null || rootName.length() == 0) {
            if (this.isTest() && "test.src.dir".equals(propName)) {
                rootName = DEFAULT_TEST_MODULE_LABEL;
            } else if (!this.isTest() && "src.dir".equals(propName)) {
                rootName = DEFAULT_MODULE_LABEL;
            } else {
                String propValue = this.evaluator.getProperty(propName);
                File sourceRoot = propValue == null ? null : this.helper.getAntProjectHelper().resolveFile(propValue);
                rootName = this.createInitialDisplayName(sourceRoot);
            }
        }
        return rootName;
    }

    @Override
    public String createInitialDisplayName(File sourceRoot) {
        String pdPath;
        String srPath;
        String rootName = sourceRoot != null ? ((srPath = sourceRoot.getAbsolutePath()).startsWith(pdPath = this.projectDir.getAbsolutePath() + File.separatorChar) ? srPath.substring(pdPath.length()) : sourceRoot.getAbsolutePath()) : (this.isTest() ? DEFAULT_TEST_MODULE_LABEL : DEFAULT_MODULE_LABEL);
        return rootName;
    }

    public String getRootPath(String rootPathProperty) {
        String prop = this.evaluator.getProperty(rootPathProperty);
        if (prop != null) {
            StringBuilder sb = new StringBuilder();
            for (String propElement : PropertyUtils.tokenizePath((String)prop)) {
                if (sb.length() > 0) {
                    sb.append(':');
                }
                sb.append(propElement);
            }
            return sb.toString();
        }
        return "";
    }

    public String createInitialPath() {
        return this.isTest() ? DEFAULT_TEST_MODULE_PATH : DEFAULT_MODULE_PATH;
    }

    private Map<URL, Pair<String, String>> getRootsToProps() {
        return (Map)ProjectManager.mutex().readAccess(() -> {
            HashMap<URL, Pair> result = new HashMap<URL, Pair>();
            String[] rootProperties = this.getRootProperties();
            String[] rootPathProperties = this.getRootPathProperties();
            assert (rootProperties.length == rootPathProperties.length);
            for (int i = 0; i < rootProperties.length; ++i) {
                String rootProp = this.evaluator.getProperty(rootProperties[i]);
                if (rootProp == null) continue;
                File f = this.helper.getAntProjectHelper().resolveFile(rootProp);
                try {
                    URL url = Utilities.toURI((File)f).toURL();
                    if (!f.exists()) {
                        url = new URL(url.toExternalForm() + "/");
                    } else if (f.isFile()) continue;
                    assert (url.toExternalForm().endsWith("/")) : "#90639 violation for " + url + "; " + f + " exists? " + f.exists() + " dir? " + f.isDirectory() + " file? " + f.isFile();
                    result.put(url, Pair.of((Object)rootProperties[i], (Object)rootPathProperties[i]));
                    continue;
                }
                catch (MalformedURLException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            return result;
        });
    }
}

