/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.css.lib.api.properties.GrammarElementVisitor;
import org.netbeans.modules.css.lib.api.properties.GroupGrammarElement;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinitionProvider;
import org.openide.filesystems.FileObject;

public class Properties {
    private Properties() {
    }

    public static Collection<String> getPropertyNames(FileObject context) {
        return PropertyDefinitionProvider.Query.getPropertyNames(context);
    }

    public static PropertyDefinition getPropertyDefinition(String propertyName) {
        return PropertyDefinitionProvider.Query.getPropertyDefinition(propertyName);
    }

    public static PropertyDefinition getPropertyDefinition(String propertyName, boolean preferInvisibleProperties) {
        StringBuilder sb = new StringBuilder().append('@').append(propertyName);
        PropertyDefinition invisibleProperty = Properties.getPropertyDefinition(sb.toString());
        return preferInvisibleProperties && invisibleProperty != null ? invisibleProperty : Properties.getPropertyDefinition(propertyName);
    }

    public static Collection<PropertyDefinition> getPropertyDefinitions(FileObject context) {
        return Properties.getPropertyDefinitions(context, false);
    }

    public static Collection<PropertyDefinition> getPropertyDefinitions(FileObject context, boolean visibleOnly) {
        ArrayList<PropertyDefinition> all = new ArrayList<PropertyDefinition>();
        for (String propName : Properties.getPropertyNames(context)) {
            PropertyDefinition propertyDefinition = Properties.getPropertyDefinition(propName);
            if (visibleOnly && !Properties.isVisibleProperty(propertyDefinition)) continue;
            all.add(propertyDefinition);
        }
        return all;
    }

    public static boolean isVisibleProperty(PropertyDefinition propertyDefinition) {
        char c = propertyDefinition.getName().charAt(0);
        return c != '@';
    }

    public static boolean isVendorSpecificProperty(PropertyDefinition propertyDefinition) {
        return Properties.isVendorSpecificPropertyName(propertyDefinition.getName());
    }

    public static boolean isVendorSpecificPropertyName(String propertyName) {
        char c = propertyName.charAt(0);
        return c == '_' || c == '-';
    }

    public static boolean isAggregatedProperty(FileObject context, PropertyDefinition propertyDefinition) {
        final GroupGrammarElement grammarElement = propertyDefinition.getGrammarElement(context);
        final AtomicBoolean isAggregated = new AtomicBoolean(false);
        grammarElement.accept(new GrammarElementVisitor(){
            private final Set<GroupGrammarElement> seen = Collections.newSetFromMap(new IdentityHashMap());

            @Override
            public boolean visit(GroupGrammarElement element) {
                PropertyDefinition subDef;
                if (this.seen.contains(element)) {
                    return false;
                }
                this.seen.add(element);
                if (element == grammarElement) {
                    return true;
                }
                String elementName = element.getName();
                if (elementName != null && (subDef = Properties.getPropertyDefinition(elementName)) != null && Properties.isVisibleProperty(subDef)) {
                    isAggregated.set(true);
                    return false;
                }
                return true;
            }
        });
        return isAggregated.get();
    }
}

