/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.openfile.OpenFile;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.ExternalDropHandler;
import org.openide.windows.TopComponent;

public class DefaultExternalDropHandler
extends ExternalDropHandler {
    private static final Logger LOG = Logger.getLogger(DefaultExternalDropHandler.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(DefaultExternalDropHandler.class);
    private static DataFlavor uriListDataFlavor;

    public boolean canDrop(DropTargetDragEvent e) {
        return this.canDrop(e.getCurrentDataFlavors());
    }

    public boolean canDrop(DropTargetDropEvent e) {
        return this.canDrop(e.getCurrentDataFlavors());
    }

    boolean canDrop(DataFlavor[] flavors) {
        for (int i = 0; null != flavors && i < flavors.length; ++i) {
            if (!DataFlavor.javaFileListFlavor.equals(flavors[i]) && !this.getUriListDataFlavor().equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    public boolean handleDrop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (null == t) {
            return false;
        }
        List<File> fileList = this.getFileList(t);
        if (fileList == null || fileList.isEmpty()) {
            return false;
        }
        for (Component c = e.getDropTargetContext().getComponent(); c != null; c = c.getParent()) {
            if (!(c instanceof TopComponent)) continue;
            ((TopComponent)c).requestActive();
            break;
        }
        Object errMsg = null;
        if (fileList.size() == 1) {
            errMsg = this.openFile(fileList.get(0));
        } else {
            boolean hasSomeSuccess = false;
            ArrayList<String> fileErrs = null;
            for (File file : fileList) {
                String fileErr = this.openFile(file);
                if (fileErr == null) {
                    hasSomeSuccess = true;
                    continue;
                }
                if (fileErrs == null) {
                    fileErrs = new ArrayList<String>(fileList.size());
                }
                fileErrs.add(fileErr);
            }
            if (fileErrs != null) {
                String mainMsgKey = hasSomeSuccess ? "MSG_could_not_open_some_files" : "MSG_could_not_open_any_file";
                String mainMsg = NbBundle.getMessage(OpenFile.class, (String)mainMsgKey);
                if (fileErrs == null) {
                    errMsg = mainMsg;
                } else {
                    JPanel msgPanel = new JPanel();
                    msgPanel.setLayout(new BoxLayout(msgPanel, 3));
                    msgPanel.add(new JLabel(mainMsg));
                    msgPanel.add(Box.createVerticalStrut(12));
                    for (String fileErr : fileErrs) {
                        msgPanel.add(new JLabel(fileErr));
                    }
                    errMsg = msgPanel;
                }
            }
        }
        if (errMsg != null) {
            DefaultExternalDropHandler.showWarningMessageFileNotOpened(errMsg);
            return false;
        }
        return true;
    }

    static void showWarningMessageFileNotOpened(Object errMsg) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message(errMsg, 2));
    }

    List<File> getFileList(Transferable t) {
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                try {
                    return (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (InvalidDnDOperationException ex) {
                    LOG.log(Level.FINE, null, ex);
                }
            }
            if (t.isDataFlavorSupported(this.getUriListDataFlavor())) {
                String uriList = (String)t.getTransferData(this.getUriListDataFlavor());
                return this.textURIListToFileList(uriList);
            }
        }
        catch (UnsupportedFlavorException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, null, ex);
        }
        return null;
    }

    String openFile(final File file) {
        Callable<String> task = new Callable<String>(){

            @Override
            public String call() {
                File normalized = FileUtil.normalizeFile((File)file);
                FileObject fo = FileUtil.toFileObject((File)normalized);
                if (fo == null) {
                    return NbBundle.getMessage(OpenFile.class, (String)"MSG_FilePathTypeNotSupported", (Object)file.toString());
                }
                return OpenFile.open(fo, -1);
            }
        };
        Future future = RP.submit((Callable)task);
        try {
            return (String)future.get(2L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            return null;
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, null, e);
            return null;
        }
        catch (ExecutionException e) {
            LOG.log(Level.INFO, null, e);
            return null;
        }
    }

    DataFlavor getUriListDataFlavor() {
        if (null == uriListDataFlavor) {
            try {
                uriListDataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
            }
            catch (ClassNotFoundException cnfE) {
                throw new AssertionError((Object)cnfE);
            }
        }
        return uriListDataFlavor;
    }

    List<File> textURIListToFileList(String data) {
        ArrayList<File> list = new ArrayList<File>(1);
        StringTokenizer st = new StringTokenizer(data, "\r\n\u0000");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                URI uri = new URI(s);
                File file = new File(uri);
                list.add(file);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return list;
    }
}

